/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import org.openbase.bco.bcozy.view.location.AbstractPolygon;

public abstract class LocationPolygon
extends AbstractPolygon {
    private boolean selected;
    private Shape cuttingShape;
    private final List<String> childIds;

    public LocationPolygon(String locationLabel, String locationId, List<String> childIds, double ... points) {
        super(locationLabel, locationId, points);
        this.childIds = childIds;
        this.selected = false;
        this.cuttingShape = this;
        this.setLocationStyle();
    }

    public List<String> getChildIds() {
        return this.childIds;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.changeStyleOnSelection(selected);
    }

    public void addCuttingShape(Shape additionalCuttingShape) {
        this.cuttingShape = Path.subtract((Shape)this.cuttingShape, (Shape)additionalCuttingShape);
        this.setClip((Node)this.cuttingShape);
    }

    protected abstract void changeStyleOnSelection(boolean var1);

    protected abstract void setLocationStyle();
}

