/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.MissingResourceException;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import org.controlsfx.control.HiddenSidesPane;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.mainmenupanes.PaneElement;
import org.openbase.bco.bcozy.view.mainmenupanes.UserPane;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.registry.UserRegistryDataType;
import rst.domotic.unit.UnitConfigType;

public class AvailableUsersPane
extends PaneElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvailableUsersPane.class);
    private final BorderPane statusIcon;
    private final VBox userPanes = new VBox(10.0);

    public AvailableUsersPane() {
        this.statusIcon = new BorderPane((Node)new SVGIcon((GlyphIcons)MaterialDesignIcon.ACCOUNT_CIRCLE, 48.0, true));
        ScrollPane verticalScrollPane = new ScrollPane();
        verticalScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        verticalScrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        ScrollBar scrollBar = new ScrollBar();
        scrollBar.setOrientation(Orientation.VERTICAL);
        HiddenSidesPane hiddenSidesPane = new HiddenSidesPane();
        hiddenSidesPane.setContent((Node)verticalScrollPane);
        hiddenSidesPane.setRight((Node)scrollBar);
        scrollBar.maxProperty().bind((ObservableValue)verticalScrollPane.vmaxProperty());
        scrollBar.minProperty().bind((ObservableValue)verticalScrollPane.vminProperty());
        verticalScrollPane.setContent((Node)this.userPanes);
        verticalScrollPane.setFitToWidth(true);
        this.getChildren().addAll((Object[])new Node[]{hiddenSidesPane});
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            Registries.getUserRegistry().addDataObserver((Observer)new Observer<UserRegistryDataType.UserRegistryData>(){

                public void update(Observable<UserRegistryDataType.UserRegistryData> source, UserRegistryDataType.UserRegistryData data) throws Exception {
                    Platform.runLater(() -> AvailableUsersPane.this.updateDynamicComponents());
                }
            });
            this.updateDynamicComponents();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void updateDynamicComponents() {
        try {
            if (!Registries.getUserRegistry().isDataAvailable()) {
                return;
            }
            new ArrayList<Node>((Collection<Node>)this.userPanes.getChildren()).forEach(userPane -> {
                ((UserPane)((Object)userPane)).shutdown();
                this.userPanes.getChildren().remove(userPane);
            });
            for (UnitConfigType.UnitConfig userUniConfig : Registries.getUserRegistry().getUserConfigs()) {
                UserPane userPane2 = new UserPane();
                userPane2.init(userUniConfig);
                this.userPanes.getChildren().add((Object)userPane2);
            }
        }
        catch (InterruptedException | MissingResourceException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException(ex), (Logger)LOGGER);
        }
    }

    @Override
    public Node getStatusIcon() {
        return this.statusIcon;
    }
}

