/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.unitpanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.unitpanes.AbstractUnitPane;
import org.openbase.bco.bcozy.view.unitpanes.BatteryPane;
import org.openbase.bco.dal.remote.unit.BrightnessSensorRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.dal.BrightnessSensorDataType;

public class BrightnessSensorPane
extends AbstractUnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatteryPane.class);
    private final BrightnessSensorRemote brightnessSensorRemote;
    private final SVGIcon brightnessIcon;
    private final Text brightnessStatus;
    private final BorderPane headContent;

    public BrightnessSensorPane(UnitRemote brightnessSensorRemote) {
        this.brightnessSensorRemote = (BrightnessSensorRemote)brightnessSensorRemote;
        this.headContent = new BorderPane();
        this.brightnessIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE, (GlyphIcons)MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE_OUTLINE, 32.0);
        this.brightnessStatus = new Text();
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, false);
        this.initEffect();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.brightnessSensorRemote.addDataObserver((Observer)this);
    }

    private void initEffect() {
        double brightnessLevel = 0.0;
        try {
            brightnessLevel = this.brightnessSensorRemote.getBrightnessState().getBrightness();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setBrightnessLevelTextAndIcon(brightnessLevel);
    }

    private void setBrightnessLevelTextAndIcon(double brightnessLevel) {
        if (brightnessLevel <= 3000.0) {
            double rootFunction = Math.sqrt(brightnessLevel / 3000.0);
            this.brightnessIcon.setBackgroundIconColorAnimated(new Color(rootFunction, rootFunction, 0.0, 1.0));
        } else {
            this.brightnessIcon.setBackgroundIconColorAnimated(new Color(1.0, 1.0, 1.0, 1.0));
        }
        this.observerText.setIdentifier("brightness");
        this.brightnessStatus.setText((int)brightnessLevel + "lx");
    }

    @Override
    protected void initTitle() {
        this.brightnessStatus.getStyleClass().add((Object)"icons");
        this.brightnessIcon.setBackgroundIconColorAnimated(Color.TRANSPARENT);
        this.iconPane.add((Node)this.brightnessIcon, 0, 0);
        this.iconPane.add((Node)this.brightnessStatus, 1, 0);
        this.iconPane.setHgap(10.0);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(this.iconPane.getHeight() + 10.0);
    }

    @Override
    protected void initContent() {
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = ((BrightnessSensorDataType.BrightnessSensorData)this.brightnessSensorRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public UnitRemote getDALRemoteService() {
        return this.brightnessSensorRemote;
    }

    @Override
    void removeObserver() {
        this.brightnessSensorRemote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object brightnessSensor) throws Exception {
        Platform.runLater(() -> {
            double brightnessLevel = ((BrightnessSensorDataType.BrightnessSensorData)brightnessSensor).getBrightnessState().getBrightness();
            this.setBrightnessLevelTextAndIcon(brightnessLevel);
        });
    }
}

