/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.unitpanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.unitpanes.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.ColorableLightRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.openbase.jul.schedule.RecurrenceEventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.dal.ColorableLightDataType;
import rst.vision.HSBColorType;

public class ColorableLightPane
extends AbstractUnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColorableLightPane.class);
    private static final double COLOR_BOX_SIZE = 150.0;
    private final ColorableLightRemote colorableLightRemote;
    private final SVGIcon lightBulbIcon;
    private final SVGIcon unknownForegroundIcon;
    private final SVGIcon unknownBackgroundIcon;
    private final BorderPane headContent;
    private final HBox bodyContent;
    private final DoubleProperty hueValue = new SimpleDoubleProperty(0.0);
    private final DoubleProperty saturation = new SimpleDoubleProperty(0.0);
    private final DoubleProperty brightness = new SimpleDoubleProperty(0.0);
    private final Rectangle rectangleSelector;
    private double rectX;
    private double rectY;
    private double angle;

    public ColorableLightPane(UnitRemote colorableLightRemote) {
        this.colorableLightRemote = (ColorableLightRemote)colorableLightRemote;
        this.lightBulbIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.LIGHTBULB, (GlyphIcons)MaterialDesignIcon.LIGHTBULB_OUTLINE, 32.0);
        this.unknownBackgroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE, 30.0, false);
        this.unknownForegroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE, 32.0, false);
        this.rectangleSelector = new Rectangle();
        this.headContent = new BorderPane();
        this.bodyContent = new HBox();
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, (Pane)this.bodyContent, true);
        this.initEffectAndSwitch();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.colorableLightRemote.addDataObserver((Observer)this);
    }

    private void initEffectAndSwitch() {
        PowerStateType.PowerState.State powerState = PowerStateType.PowerState.State.OFF;
        HSBColorType.HSBColor currentColor = HSBColorType.HSBColor.newBuilder().build();
        try {
            powerState = this.colorableLightRemote.getPowerState().getValue();
            currentColor = this.colorableLightRemote.getHSBColor();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        Color color = Color.hsb((double)currentColor.getHue(), (double)(currentColor.getSaturation() / 100.0), (double)(currentColor.getBrightness() / 100.0));
        this.hueValue.set(color.getHue());
        this.angle = color.getHue();
        this.rectangleSelector.setY(0.0);
        this.rectSelectorCoordinates();
        this.rectangleSelector.setLayoutX(this.rectX);
        this.rectangleSelector.setLayoutY(this.rectY);
        this.rectangleSelector.setRotate(this.angle);
        this.setEffectColorAndSwitch(powerState, color);
    }

    private void setEffectColorAndSwitch(PowerStateType.PowerState.State powerState, Color color) {
        this.iconPane.getChildren().clear();
        switch (powerState) {
            case ON: {
                this.iconPane.add((Node)this.lightBulbIcon, 0, 0);
                this.lightBulbIcon.setBackgroundIconColorAnimated(color);
                this.observerText.setIdentifier("lightOn");
                if (this.toggleSwitch.isSelected()) break;
                this.toggleSwitch.setSelected(true);
                break;
            }
            case OFF: {
                this.iconPane.add((Node)this.lightBulbIcon, 0, 0);
                this.lightBulbIcon.setBackgroundIconColorAnimated(Color.TRANSPARENT);
                this.observerText.setIdentifier("lightOff");
                if (!this.toggleSwitch.isSelected()) break;
                this.toggleSwitch.setSelected(false);
                break;
            }
            default: {
                this.iconPane.add((Node)this.unknownBackgroundIcon, 0, 0);
                this.iconPane.add((Node)this.unknownForegroundIcon, 0, 0);
                this.observerText.setIdentifier("unknown");
            }
        }
    }

    private Image colorSpectrumImage(int width, int height, Stop ... stops) {
        WritableImage writableImage = new WritableImage(width, height);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        Color color = Color.TRANSPARENT;
        Point2D center = new Point2D((double)width / 2.0, (double)height / 2.0);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double deltaX = (double)x - center.getX();
                double deltaY = (double)y - center.getY();
                double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
                double angle = Math.abs(Math.toDegrees(Math.acos(deltaX / distance)));
                if (deltaX >= 0.0 && deltaY <= 0.0) {
                    angle = 90.0 - angle;
                } else if (deltaX >= 0.0 && deltaY >= 0.0) {
                    angle += 90.0;
                } else if (deltaX <= 0.0 && deltaY >= 0.0) {
                    angle += 90.0;
                } else if (deltaX <= 0.0 && deltaY <= 0.0) {
                    angle = 450.0 - angle;
                }
                for (int i = 0; i < stops.length - 1; ++i) {
                    double offset = stops[i].getOffset();
                    double nextOffset = stops[i + 1].getOffset();
                    if (!(angle >= offset * 360.0) || !(angle < nextOffset * 360.0)) continue;
                    double fraction = (angle - offset * 360.0) / ((nextOffset - offset) * 360.0);
                    color = this.interpolateColor(stops[i].getColor(), stops[i + 1].getColor(), fraction);
                }
                pixelWriter.setColor(x, y, color);
            }
        }
        return writableImage;
    }

    private Color interpolateColor(Color colorOne, Color colorTwo, double fraction) {
        double red = colorOne.getRed() + (colorTwo.getRed() - colorOne.getRed()) * fraction;
        double green = colorOne.getGreen() + (colorTwo.getGreen() - colorOne.getGreen()) * fraction;
        double blue = colorOne.getBlue() + (colorTwo.getBlue() - colorOne.getBlue()) * fraction;
        double opacity = colorOne.getOpacity() + (colorTwo.getOpacity() - colorOne.getOpacity()) * fraction;
        red = ColorableLightPane.clamp(red);
        green = ColorableLightPane.clamp(green);
        blue = ColorableLightPane.clamp(blue);
        opacity = ColorableLightPane.clamp(opacity);
        return Color.color((double)red, (double)green, (double)blue, (double)opacity);
    }

    static double clamp(double value) {
        return value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value);
    }

    private Stop[] hueStops() {
        Stop[] stops = new Stop[255];
        for (int i = 0; i < 255; ++i) {
            double offset = 0.00392156862745098 * (double)i;
            int hue = (int)((double)((float)i / 255.0f) * 360.0);
            stops[i] = new Stop(offset, Color.hsb((double)hue, (double)1.0, (double)1.0));
        }
        return stops;
    }

    private Circle circleSelector() {
        Circle circle = new Circle(10.0, (Paint)Color.web((String)"white", (double)0.0));
        circle.getStyleClass().add((Object)"circle-selector");
        circle.setMouseTransparent(true);
        circle.setStroke((Paint)Color.web((String)"white", (double)1.0));
        circle.setCache(true);
        circle.setManaged(false);
        circle.setEffect((Effect)this.dropShadow());
        return circle;
    }

    private DropShadow dropShadow() {
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX(1.0);
        dropShadow.setOffsetY(1.0);
        dropShadow.setColor(Color.BLACK);
        return dropShadow;
    }

    private Pane saturationRect() {
        Pane colorRectSaturation = new Pane();
        colorRectSaturation.setPrefSize(150.0, 150.0);
        colorRectSaturation.setMinSize(150.0, 150.0);
        colorRectSaturation.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)255, (int)255, (int)255, (double)1.0)), new Stop(1.0, Color.rgb((int)255, (int)255, (int)255, (double)0.0))}), CornerRadii.EMPTY, Insets.EMPTY)}));
        return colorRectSaturation;
    }

    private Pane brightnessRect() {
        Pane colorRectBrightness = new Pane();
        colorRectBrightness.setPrefSize(150.0, 150.0);
        colorRectBrightness.setMinSize(150.0, 150.0);
        colorRectBrightness.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)0, (int)0, (int)0, (double)0.0)), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)1.0))}), CornerRadii.EMPTY, Insets.EMPTY)}));
        return colorRectBrightness;
    }

    private Shape hollowCircle() {
        Circle circleTall = new Circle(75.0);
        Circle circleSmall = new Circle(circleTall.getRadius() - 25.0);
        Shape hollowCircle = Path.subtract((Shape)circleTall, (Shape)circleSmall);
        Stop[] hueFraction = this.hueStops();
        ImagePattern imagePattern = new ImagePattern(this.colorSpectrumImage(150, 150, hueFraction));
        hollowCircle.setLayoutX(circleTall.getRadius());
        hollowCircle.setLayoutY(circleTall.getRadius());
        hollowCircle.setFill((Paint)imagePattern);
        return hollowCircle;
    }

    private void sendStateToRemote(PowerStateType.PowerState.State powerState) {
        try {
            this.colorableLightRemote.setPowerState(powerState).get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException | CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER);
            this.setWidgetPaneDisable(true);
        }
    }

    @Override
    protected void initTitle() {
        this.oneClick.addListener((observable, oldValue, newValue) -> GlobalCachedExecutorService.submit((Runnable)new Task(){

            protected Object call() {
                if (ColorableLightPane.this.toggleSwitch.isSelected()) {
                    ColorableLightPane.this.sendStateToRemote(PowerStateType.PowerState.State.OFF);
                } else {
                    ColorableLightPane.this.sendStateToRemote(PowerStateType.PowerState.State.ON);
                }
                return null;
            }
        }));
        this.toggleSwitch.setOnMouseClicked(event -> GlobalCachedExecutorService.submit((Runnable)new Task(){

            protected Object call() {
                if (ColorableLightPane.this.toggleSwitch.isSelected()) {
                    ColorableLightPane.this.sendStateToRemote(PowerStateType.PowerState.State.ON);
                } else {
                    ColorableLightPane.this.sendStateToRemote(PowerStateType.PowerState.State.OFF);
                }
                return null;
            }
        }));
        this.unknownForegroundIcon.setForegroundIconColor(Color.BLUE);
        this.unknownBackgroundIcon.setForegroundIconColor(Color.WHITE);
        this.lightBulbIcon.setBackgroundIconColorAnimated(Color.TRANSPARENT);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(this.lightBulbIcon.getSize() + 10.0 + 1.0);
    }

    private void sendHSV2Remote() {
        HSBColorType.HSBColor hsvColor = HSBColorType.HSBColor.newBuilder().setHue((double)this.hueValue.floatValue()).setSaturation((double)this.saturation.floatValue()).setBrightness((double)this.brightness.floatValue()).build();
        try {
            this.colorableLightRemote.setColor(hsvColor).get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            this.setWidgetPaneDisable(true);
        }
    }

    @Override
    protected void initContent() {
        StackPane colorRectContainer = new StackPane();
        Pane colorHue = new Pane();
        Circle circle = this.circleSelector();
        Shape hollowCircle = this.hollowCircle();
        Rectangle clip = new Rectangle(0.0, 0.0, 0.0, 0.0);
        Pane colorCircleContainer = new Pane();
        colorCircleContainer.setPrefSize(150.0, 150.0);
        colorCircleContainer.setMinSize(150.0, 150.0);
        colorCircleContainer.maxHeightProperty().bind((ObservableValue)colorCircleContainer.prefWidthProperty());
        colorHue.setMinSize(150.0, 150.0);
        colorHue.setPrefSize(150.0, 150.0);
        colorHue.backgroundProperty().bind((ObservableValue)new ObjectBinding<Background>(){
            {
                this.bind(new Observable[]{ColorableLightPane.this.hueValue});
            }

            protected Background computeValue() {
                return new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.hsb((double)ColorableLightPane.this.hueValue.getValue(), (double)1.0, (double)1.0), CornerRadii.EMPTY, Insets.EMPTY)});
            }
        });
        circle.layoutXProperty().bind((ObservableValue)this.saturation.divide(100).multiply(150.0));
        circle.layoutYProperty().bind((ObservableValue)Bindings.subtract((int)1, (ObservableNumberValue)this.brightness.divide(100)).multiply(150.0));
        EventHandler colorContainerMouseHandler = event -> GlobalCachedExecutorService.submit((Runnable)new Task((MouseEvent)event){
            final /* synthetic */ MouseEvent val$event;
            {
                this.val$event = mouseEvent;
            }

            protected Object call() {
                double xMouse = this.val$event.getX();
                double yMouse = this.val$event.getY();
                ColorableLightPane.this.saturation.set(ColorableLightPane.clamp(xMouse / 150.0) * 100.0);
                ColorableLightPane.this.brightness.set(100.0 - ColorableLightPane.clamp(yMouse / 150.0) * 100.0);
                RecurrenceEventFilter recurrenceEventFilter = new RecurrenceEventFilter(){

                    public void relay() {
                        ColorableLightPane.this.sendHSV2Remote();
                    }
                };
                recurrenceEventFilter.trigger();
                return null;
            }
        });
        colorRectContainer.setMinSize(150.0, 150.0);
        colorRectContainer.setPrefSize(150.0, 150.0);
        colorRectContainer.maxHeightProperty().bind((ObservableValue)colorRectContainer.prefWidthProperty());
        colorRectContainer.getChildren().addAll((Object[])new Node[]{colorHue, this.saturationRect(), this.brightnessRect(), circle});
        colorRectContainer.setOnMousePressed(colorContainerMouseHandler);
        colorRectContainer.setOnMouseDragged(colorContainerMouseHandler);
        this.rectangleSelector.setWidth(15.0);
        this.rectangleSelector.setHeight(25.0);
        this.rectangleSelector.setFill((Paint)Color.web((String)"white", (double)0.0));
        this.rectangleSelector.getStyleClass().add((Object)"rectangle-selector");
        this.rectangleSelector.setMouseTransparent(true);
        this.rectangleSelector.setTranslateX(-this.rectangleSelector.getWidth() / 2.0);
        this.rectangleSelector.setTranslateY(-this.rectangleSelector.getHeight() / 2.0);
        this.rectangleSelector.setLayoutX(75.0);
        this.rectangleSelector.setLayoutY(75.0);
        this.rectangleSelector.setY((this.rectangleSelector.getHeight() - 150.0) / 2.0);
        this.rectangleSelector.setStroke((Paint)Color.web((String)"white", (double)1.0));
        this.rectangleSelector.setCache(true);
        this.rectangleSelector.setManaged(false);
        this.rectangleSelector.setEffect((Effect)this.dropShadow());
        EventHandler colorCircleMouseHandler = event -> GlobalCachedExecutorService.submit((Runnable)new Task((MouseEvent)event){
            final /* synthetic */ MouseEvent val$event;
            {
                this.val$event = mouseEvent;
            }

            protected Object call() {
                double yMouse = this.val$event.getY();
                double xMouse = this.val$event.getX();
                ColorableLightPane.this.angle = (Math.toDegrees(Math.atan2(yMouse, xMouse)) + 360.0 + 90.0) % 360.0;
                ColorableLightPane.this.hueValue.set(ColorableLightPane.this.angle);
                ColorableLightPane.this.rectSelectorCoordinates();
                ColorableLightPane.this.rectangleSelector.setLayoutX(ColorableLightPane.this.rectX);
                ColorableLightPane.this.rectangleSelector.setLayoutY(ColorableLightPane.this.rectY);
                ColorableLightPane.this.rectangleSelector.setRotate(ColorableLightPane.this.angle);
                RecurrenceEventFilter recurrenceEventFilter = new RecurrenceEventFilter(){

                    public void relay() {
                        ColorableLightPane.this.sendHSV2Remote();
                    }
                };
                recurrenceEventFilter.trigger();
                return null;
            }
        });
        hollowCircle.setOnMousePressed(colorCircleMouseHandler);
        hollowCircle.setOnMouseDragged(colorCircleMouseHandler);
        colorCircleContainer.getChildren().addAll((Object[])new Node[]{hollowCircle, this.rectangleSelector});
        this.bodyContent.getChildren().addAll((Object[])new Node[]{colorRectContainer, colorCircleContainer});
        this.bodyContent.prefHeightProperty().set(160.0);
        clip.widthProperty().bind((ObservableValue)this.bodyContent.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.bodyContent.heightProperty());
        this.bodyContent.setClip((Node)clip);
    }

    private void rectSelectorCoordinates() {
        this.rectX = Math.round(75.0 + (150.0 - this.rectangleSelector.getHeight()) / 2.0 * Math.cos(Math.toRadians((this.angle + 270.0) % 360.0)));
        this.rectY = Math.round(75.0 + (150.0 - this.rectangleSelector.getHeight()) / 2.0 * Math.sin(Math.toRadians((this.angle + 270.0) % 360.0)));
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = ((ColorableLightDataType.ColorableLightData)this.colorableLightRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public UnitRemote getDALRemoteService() {
        return this.colorableLightRemote;
    }

    @Override
    void removeObserver() {
        this.colorableLightRemote.removeObserver((Observer)this);
    }

    public void update(org.openbase.jul.pattern.Observable observable, Object colorableLight) throws Exception {
        Platform.runLater(() -> {
            if (this.isDisabled()) {
                this.setWidgetPaneDisable(false);
            }
            PowerStateType.PowerState.State powerState = ((ColorableLightDataType.ColorableLightData)colorableLight).getPowerState().getValue();
            Color color = Color.hsb((double)((ColorableLightDataType.ColorableLightData)colorableLight).getColorState().getColor().getHsbColor().getHue(), (double)(((ColorableLightDataType.ColorableLightData)colorableLight).getColorState().getColor().getHsbColor().getSaturation() / 100.0), (double)(((ColorableLightDataType.ColorableLightData)colorableLight).getColorState().getColor().getHsbColor().getBrightness() / 100.0));
            this.setEffectColorAndSwitch(powerState, color);
        });
    }
}

