/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.unitpanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.Constants;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.unitpanes.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.DimmableLightRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.openbase.jul.schedule.RecurrenceEventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.dal.DimmableLightDataType;

public class DimmableLightPane
extends AbstractUnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(DimmableLightPane.class);
    private RecurrenceEventFilter recurrenceEventFilter;
    private final SVGIcon unknownForegroundIcon;
    private final SVGIcon unknownBackgroundIcon;
    private final DimmableLightRemote dimmableLightRemote;
    private final ProgressBar progressBar;
    private final BorderPane headContent;
    private final SVGIcon lightBulbIcon;
    private final StackPane stackPane;
    private final VBox bodyContent;
    private final Slider slider;
    private final EventHandler<MouseEvent> sendBrightness = event -> GlobalCachedExecutorService.submit((Runnable)new Task(){

        protected Object call() {
            try {
                DimmableLightPane.this.dimmableLightRemote.setBrightnessState(BrightnessStateType.BrightnessState.newBuilder().setBrightness(DimmableLightPane.this.slider.getValue()).build()).get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException | CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                DimmableLightPane.this.setWidgetPaneDisable(true);
            }
            return null;
        }
    });

    public DimmableLightPane(UnitRemote dimmerRemote) {
        this.dimmableLightRemote = (DimmableLightRemote)dimmerRemote;
        this.lightBulbIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.LIGHTBULB, (GlyphIcons)MaterialDesignIcon.LIGHTBULB_OUTLINE, 32.0);
        this.unknownBackgroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE, 30.0, false);
        this.unknownForegroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE, 32.0, false);
        this.progressBar = new ProgressBar();
        this.headContent = new BorderPane();
        this.stackPane = new StackPane();
        this.bodyContent = new VBox();
        this.slider = new Slider();
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, (Pane)this.bodyContent, true);
        this.initEffectAndSwitch();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.dimmableLightRemote.addDataObserver((Observer)this);
    }

    private void initEffectAndSwitch() {
        PowerStateType.PowerState.State powerState = PowerStateType.PowerState.State.OFF;
        double brightness = 0.0;
        try {
            powerState = this.dimmableLightRemote.getPowerState().getValue();
            brightness = this.dimmableLightRemote.getBrightnessState().getBrightness() / 100.0;
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setEffectColorAndSlider(powerState, brightness);
    }

    private void setEffectColorAndSlider(PowerStateType.PowerState.State powerState, double brightness) {
        this.iconPane.getChildren().clear();
        if (powerState.equals((Object)PowerStateType.PowerState.State.ON)) {
            this.iconPane.add((Node)this.lightBulbIcon, 0, 0);
            Color color = Color.hsb((double)Constants.LIGHTBULB_COLOR.getHue(), (double)Constants.LIGHTBULB_COLOR.getSaturation(), (double)brightness, (double)Constants.LIGHTBULB_COLOR.getOpacity());
            this.lightBulbIcon.setBackgroundIconColorAnimated(color);
            this.progressBar.setProgress(brightness);
            this.slider.setValue(brightness * this.slider.getMax());
            this.observerText.setIdentifier("lightOn");
            if (!this.toggleSwitch.isSelected()) {
                this.toggleSwitch.setSelected(true);
            }
        } else if (powerState.equals((Object)PowerStateType.PowerState.State.OFF)) {
            this.iconPane.add((Node)this.lightBulbIcon, 0, 0);
            this.lightBulbIcon.setBackgroundIconColorAnimated(Color.TRANSPARENT);
            this.progressBar.setProgress(0.0);
            this.slider.setValue(0.0);
            this.observerText.setIdentifier("lightOff");
            if (this.toggleSwitch.isSelected()) {
                this.toggleSwitch.setSelected(false);
            }
        } else {
            this.iconPane.add((Node)this.unknownBackgroundIcon, 0, 0);
            this.iconPane.add((Node)this.unknownForegroundIcon, 0, 0);
            this.observerText.setIdentifier("unknown");
        }
    }

    private void sendStateToRemote(PowerStateType.PowerState.State state) {
        try {
            this.dimmableLightRemote.setPowerState(state).get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            this.setWidgetPaneDisable(true);
        }
    }

    @Override
    protected void initTitle() {
        this.lightBulbIcon.setBackgroundIconColorAnimated(Color.TRANSPARENT);
        this.oneClick.addListener((observable, oldValue, newValue) -> GlobalCachedExecutorService.submit((Runnable)new Task(){

            protected Object call() {
                if (DimmableLightPane.this.toggleSwitch.isSelected()) {
                    DimmableLightPane.this.sendStateToRemote(PowerStateType.PowerState.State.OFF);
                } else {
                    DimmableLightPane.this.sendStateToRemote(PowerStateType.PowerState.State.ON);
                }
                return null;
            }
        }));
        this.toggleSwitch.setOnMouseClicked(event -> GlobalCachedExecutorService.submit((Runnable)new Task(){

            protected Object call() {
                if (DimmableLightPane.this.toggleSwitch.isSelected()) {
                    DimmableLightPane.this.sendStateToRemote(PowerStateType.PowerState.State.ON);
                } else {
                    DimmableLightPane.this.sendStateToRemote(PowerStateType.PowerState.State.OFF);
                }
                return null;
            }
        }));
        this.unknownForegroundIcon.setForegroundIconColor(Color.BLUE);
        this.unknownBackgroundIcon.setForegroundIconColor(Color.WHITE);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(this.lightBulbIcon.getSize() + 10.0);
    }

    @Override
    protected void initContent() {
        double sliderWidth = 200.0;
        this.slider.setPrefHeight(25.0);
        this.slider.setMinHeight(25.0);
        this.slider.setMin(0.0);
        this.slider.setMax(100.0);
        this.slider.setMinWidth(200.0);
        this.slider.setMaxWidth(200.0);
        this.recurrenceEventFilter = new RecurrenceEventFilter(100L){

            public void relay() {
                DimmableLightPane.this.slider.setOnMouseDragged(DimmableLightPane.this.sendBrightness);
                DimmableLightPane.this.slider.setOnMouseClicked(DimmableLightPane.this.sendBrightness);
            }
        };
        this.recurrenceEventFilter.trigger();
        this.progressBar.setMinWidth(200.0);
        this.progressBar.setMaxWidth(200.0);
        this.stackPane.getStyleClass().clear();
        this.stackPane.getStyleClass().add((Object)"dimmer-body");
        this.stackPane.getChildren().addAll((Object[])new Node[]{this.progressBar, this.slider});
        this.bodyContent.getChildren().add((Object)this.stackPane);
        this.bodyContent.prefHeightProperty().set(this.slider.getPrefHeight() + 10.0);
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = ((DimmableLightDataType.DimmableLightData)this.dimmableLightRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public UnitRemote getDALRemoteService() {
        return this.dimmableLightRemote;
    }

    @Override
    void removeObserver() {
        this.dimmableLightRemote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object dimmer) throws Exception {
        Platform.runLater(() -> {
            PowerStateType.PowerState.State powerState = ((DimmableLightDataType.DimmableLightData)dimmer).getPowerState().getValue();
            double brightness = ((DimmableLightDataType.DimmableLightData)dimmer).getBrightnessState().getBrightness() / 100.0;
            this.setEffectColorAndSlider(powerState, brightness);
        });
    }
}

