/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.unitpanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.unitpanes.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.TamperDetectorRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.TamperStateType;
import rst.domotic.unit.dal.TamperDetectorDataType;

public class TamperDetectorPane
extends AbstractUnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(TamperDetectorPane.class);
    private final TamperDetectorRemote remote;
    private final SVGIcon tamperSwitchIconOk;
    private final SVGIcon tamperSwitchIconManipulation;
    private final SVGIcon unknownForegroundIcon;
    private final SVGIcon unknownBackgroundIcon;
    private final BorderPane headContent;

    public TamperDetectorPane(UnitRemote tamperSwitchRemote) {
        this.remote = (TamperDetectorRemote)tamperSwitchRemote;
        this.headContent = new BorderPane();
        this.tamperSwitchIconOk = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_MARKED_CIRCLE, 32.0, false);
        this.tamperSwitchIconManipulation = new SVGIcon((GlyphIcons)MaterialDesignIcon.ALERT_CIRCLE, 32.0, false);
        this.unknownBackgroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE, 30.0, false);
        this.unknownForegroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE, 32.0, false);
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, false);
        this.initEffect();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.remote.addDataObserver((Observer)this);
    }

    private void initEffect() {
        TamperStateType.TamperState.State tamperSwitchState = TamperStateType.TamperState.State.UNKNOWN;
        try {
            tamperSwitchState = this.remote.getTamperState().getValue();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setTamperSwitchIconAndText(tamperSwitchState);
    }

    private void setTamperSwitchIconAndText(TamperStateType.TamperState.State tamperSwitchState) {
        this.iconPane.getChildren().clear();
        if (null != tamperSwitchState) {
            switch (tamperSwitchState) {
                case NO_TAMPER: {
                    this.iconPane.add((Node)this.tamperSwitchIconOk, 0, 0);
                    this.observerText.setIdentifier("noTamper");
                    break;
                }
                case TAMPER: {
                    this.iconPane.add((Node)this.tamperSwitchIconManipulation, 0, 0);
                    this.observerText.setIdentifier("tamper");
                    break;
                }
                default: {
                    this.iconPane.add((Node)this.unknownBackgroundIcon, 0, 0);
                    this.iconPane.add((Node)this.unknownForegroundIcon, 0, 0);
                    this.observerText.setIdentifier("unknown");
                }
            }
        }
    }

    @Override
    protected void initTitle() {
        this.unknownForegroundIcon.setForegroundIconColor(Color.BLUE);
        this.unknownBackgroundIcon.setForegroundIconColor(Color.WHITE);
        this.tamperSwitchIconOk.setForegroundIconColor(Color.GREEN);
        this.tamperSwitchIconManipulation.setForegroundIconColor(Color.RED);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(this.tamperSwitchIconOk.getSize() + 10.0);
    }

    @Override
    protected void initContent() {
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = this.remote.getLocationConfig().getLabel() + " " + ((TamperDetectorDataType.TamperDetectorData)this.remote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public UnitRemote getDALRemoteService() {
        return this.remote;
    }

    @Override
    void removeObserver() {
        this.remote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object tamperSwitch) throws Exception {
        Platform.runLater(() -> {
            TamperStateType.TamperState.State tamperSwitchState = ((TamperDetectorDataType.TamperDetectorData)tamperSwitch).getTamperState().getValue();
            this.setTamperSwitchIconAndText(tamperSwitchState);
        });
    }
}

