/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.unitpanes;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.openbase.bco.bcozy.view.mainmenupanes.ObserverTitledPane;
import org.openbase.bco.bcozy.view.unitpanes.AbstractUnitPane;
import org.openbase.bco.bcozy.view.unitpanes.AgentPane;
import org.openbase.bco.bcozy.view.unitpanes.AppPane;
import org.openbase.bco.bcozy.view.unitpanes.BatteryPane;
import org.openbase.bco.bcozy.view.unitpanes.BrightnessSensorPane;
import org.openbase.bco.bcozy.view.unitpanes.ColorableLightPane;
import org.openbase.bco.bcozy.view.unitpanes.DimmableLightPane;
import org.openbase.bco.bcozy.view.unitpanes.LightPane;
import org.openbase.bco.bcozy.view.unitpanes.MotionDetectorPane;
import org.openbase.bco.bcozy.view.unitpanes.PowerConsumptionSensorPane;
import org.openbase.bco.bcozy.view.unitpanes.PowerSwitchPane;
import org.openbase.bco.bcozy.view.unitpanes.ReedContactPane;
import org.openbase.bco.bcozy.view.unitpanes.RollerShutterPane;
import org.openbase.bco.bcozy.view.unitpanes.ScenePane;
import org.openbase.bco.bcozy.view.unitpanes.SmokeDetectorPane;
import org.openbase.bco.bcozy.view.unitpanes.TamperDetectorPane;
import org.openbase.bco.bcozy.view.unitpanes.TemperatureControllerPane;
import org.openbase.bco.bcozy.view.unitpanes.TemperatureSensorPane;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitTemplateType;

public class UnitPaneContainer
extends ObserverTitledPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitPaneContainer.class);
    private final VBox vBox = new VBox();

    public UnitPaneContainer(String unitTypeName) {
        super(unitTypeName);
        this.vBox.getStyleClass().add((Object)"observer-titled-pane");
        this.getStyleClass().add((Object)"observer-titled-pane");
        this.setContent((Node)this.vBox);
    }

    public boolean createAndAddNewUnitPanes(UnitTemplateType.UnitTemplate.UnitType unitType, List<UnitRemote> dalRemoteServiceList) {
        this.setExpanded(false);
        switch (unitType) {
            case AGENT: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    AgentPane agentPane = new AgentPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)agentPane);
                }
                break;
            }
            case COLORABLE_LIGHT: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    ColorableLightPane ambientLightPane = new ColorableLightPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)ambientLightPane);
                }
                break;
            }
            case APP: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    AppPane appPane = new AppPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)appPane);
                }
                break;
            }
            case BATTERY: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    BatteryPane batteryPanePane = new BatteryPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)batteryPanePane);
                }
                break;
            }
            case BRIGHTNESS_SENSOR: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    BrightnessSensorPane brightnessSensorPane = new BrightnessSensorPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)brightnessSensorPane);
                }
                break;
            }
            case DIMMABLE_LIGHT: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    DimmableLightPane dimmerPane = new DimmableLightPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)dimmerPane);
                }
                break;
            }
            case LIGHT: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    LightPane lightPane = new LightPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)lightPane);
                }
                break;
            }
            case MOTION_DETECTOR: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    MotionDetectorPane motionSensorPane = new MotionDetectorPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)motionSensorPane);
                }
                break;
            }
            case POWER_CONSUMPTION_SENSOR: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    PowerConsumptionSensorPane powerConsumptionSensorPane = new PowerConsumptionSensorPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)powerConsumptionSensorPane);
                }
                break;
            }
            case POWER_SWITCH: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    PowerSwitchPane powerPlugPane = new PowerSwitchPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)powerPlugPane);
                }
                break;
            }
            case REED_CONTACT: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    ReedContactPane reedSwitchPane = new ReedContactPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)reedSwitchPane);
                }
                break;
            }
            case ROLLER_SHUTTER: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    RollerShutterPane rollerShutterPane = new RollerShutterPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)rollerShutterPane);
                }
                break;
            }
            case SCENE: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    ScenePane scenePane = new ScenePane(dalRemoteService);
                    this.vBox.getChildren().add((Object)scenePane);
                }
                break;
            }
            case SMOKE_DETECTOR: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    SmokeDetectorPane smokeDetectorPane = new SmokeDetectorPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)smokeDetectorPane);
                }
                break;
            }
            case TAMPER_DETECTOR: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    TamperDetectorPane tamperSwitchPane = new TamperDetectorPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)tamperSwitchPane);
                }
                break;
            }
            case TEMPERATURE_CONTROLLER: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    TemperatureControllerPane temperatureControllerPane = new TemperatureControllerPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)temperatureControllerPane);
                }
                break;
            }
            case TEMPERATURE_SENSOR: {
                for (UnitRemote dalRemoteService : dalRemoteServiceList) {
                    TemperatureSensorPane temperatureSensorPane = new TemperatureSensorPane(dalRemoteService);
                    this.vBox.getChildren().add((Object)temperatureSensorPane);
                }
                break;
            }
            default: {
                LOGGER.info("UnitType[" + unitType + "] is not supported yet!");
                return false;
            }
        }
        return true;
    }

    public void clearUnitPaneContainer() {
        for (Node node : this.vBox.getChildren()) {
            ((AbstractUnitPane)node).removeObserver();
        }
        this.getChildren().clear();
    }
}

