/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.unitpanes;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.PauseTransition;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.controlsfx.control.ToggleSwitch;
import org.openbase.bco.bcozy.view.ObserverText;

public class WidgetPane
extends VBox {
    protected final ObserverText observerText = new ObserverText("dummy");
    protected final BooleanProperty oneClick = new SimpleBooleanProperty(false);
    protected final ToggleSwitch toggleSwitch = new ToggleSwitch();
    protected final GridPane iconPane = new GridPane();
    protected final Tooltip tooltip = new Tooltip("");
    private final SimpleBooleanProperty isExpanded = new SimpleBooleanProperty();
    private Timeline timelineUp;
    private Timeline timelineDown;

    public WidgetPane() {
        this.getStyleClass().add((Object)"widget-pane");
    }

    public void createWidgetPane(BorderPane headContent, Pane bodyContent, boolean oneClickActivatable) {
        this.headPart(headContent, true, oneClickActivatable);
        this.bodyPart(bodyContent);
        this.setAnimation(headContent, bodyContent);
        this.isExpanded.set(false);
        this.isExpanded.addListener((paramObservableValue, paramT1, paramT2) -> {
            if (paramT2.booleanValue()) {
                this.timelineDown.play();
            } else {
                this.timelineUp.play();
            }
        });
        this.setMinHeight(headContent.prefHeightProperty().getValue());
        this.setMaxHeight(headContent.prefHeightProperty().getValue());
    }

    public void createWidgetPane(BorderPane headContent, boolean oneClickActivatable) {
        this.headPart(headContent, false, oneClickActivatable);
        this.isExpanded.set(false);
    }

    private void headPart(BorderPane headContent, boolean withBody, boolean oneClickActivatable) {
        this.toggleSwitch.setMouseTransparent(true);
        if (oneClickActivatable) {
            headContent.setRight((Node)this.toggleSwitch);
        }
        headContent.getStyleClass().clear();
        headContent.getStyleClass().add((Object)"head-pane");
        headContent.setLeft((Node)this.iconPane);
        this.observeMouseClicks(headContent, withBody, oneClickActivatable);
        Tooltip.install((Node)this.iconPane, (Tooltip)this.tooltip);
        if (headContent.getCenter() != null) {
            BorderPane.setMargin((Node)headContent.getCenter(), (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        }
        if (headContent.getRight() != null) {
            BorderPane.setMargin((Node)headContent.getRight(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        }
        this.getChildren().add((Object)headContent);
    }

    private void observeMouseClicks(BorderPane headContent, boolean withBody, boolean activatable) {
        if (withBody) {
            Duration maxTimeIntervalClick = Duration.millis((double)400.0);
            PauseTransition clickTimer = new PauseTransition(maxTimeIntervalClick);
            SimpleIntegerProperty clickCnt = new SimpleIntegerProperty(0);
            clickTimer.setOnFinished(arg_0 -> this.lambda$observeMouseClicks$1((IntegerProperty)clickCnt, arg_0));
            headContent.setOnMouseClicked(arg_0 -> this.lambda$observeMouseClicks$2((IntegerProperty)clickCnt, clickTimer, arg_0));
        } else if (activatable) {
            headContent.setOnMouseClicked(event -> this.oneClickBoolFlag());
        }
    }

    private void bodyPart(Pane bodyContent) {
        bodyContent.getStyleClass().clear();
        bodyContent.getStyleClass().addAll((Object[])new String[]{"body-pane"});
        this.getChildren().add((Object)bodyContent);
    }

    private void oneClickBoolFlag() {
        if (this.oneClick.get()) {
            this.oneClick.set(false);
        } else {
            this.oneClick.set(true);
        }
    }

    private void toggleVisibility() {
        if (this.isExpanded.get()) {
            this.isExpanded.set(false);
        } else {
            this.isExpanded.set(true);
        }
    }

    private void setAnimation(BorderPane headContent, Pane bodyContent) {
        Rectangle rectangleClip = new Rectangle(2.147483647E9, headContent.prefHeightProperty().getValue().doubleValue());
        this.setClip((Node)rectangleClip);
        this.timelineDown = new Timeline();
        this.timelineUp = new Timeline();
        this.timelineDown.setCycleCount(0);
        this.timelineDown.setAutoReverse(true);
        KeyValue kvDwn1 = new KeyValue((WritableValue)rectangleClip.heightProperty(), (Object)(headContent.prefHeightProperty().getValue() + bodyContent.prefHeightProperty().getValue()));
        KeyValue kvDwn2 = new KeyValue((WritableValue)rectangleClip.translateYProperty(), (Object)0);
        KeyValue kvDwn3 = new KeyValue((WritableValue)bodyContent.prefHeightProperty(), (Object)bodyContent.prefHeightProperty().getValue());
        KeyValue kvDwn4 = new KeyValue((WritableValue)bodyContent.translateYProperty(), (Object)0);
        KeyValue kvDwn5 = new KeyValue((WritableValue)this.maxHeightProperty(), (Object)(headContent.prefHeightProperty().getValue() + bodyContent.prefHeightProperty().getValue()));
        KeyValue kvDwn6 = new KeyValue((WritableValue)this.minHeightProperty(), (Object)(headContent.prefHeightProperty().getValue() + bodyContent.prefHeightProperty().getValue()));
        KeyFrame kfDwn = new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{kvDwn1, kvDwn2, kvDwn3, kvDwn4, kvDwn5, kvDwn6});
        this.timelineDown.getKeyFrames().add((Object)kfDwn);
        this.timelineUp.setCycleCount(1);
        this.timelineUp.setAutoReverse(true);
        KeyValue kvUp1 = new KeyValue((WritableValue)rectangleClip.heightProperty(), (Object)headContent.prefHeightProperty().getValue());
        KeyValue kvUp2 = new KeyValue((WritableValue)rectangleClip.translateYProperty(), (Object)0);
        KeyValue kvUp3 = new KeyValue((WritableValue)bodyContent.prefHeightProperty(), (Object)0);
        KeyValue kvUp4 = new KeyValue((WritableValue)bodyContent.translateYProperty(), (Object)0);
        KeyValue kvUp5 = new KeyValue((WritableValue)this.maxHeightProperty(), (Object)headContent.prefHeightProperty().getValue());
        KeyValue kvUp6 = new KeyValue((WritableValue)this.minHeightProperty(), (Object)headContent.prefHeightProperty().getValue());
        KeyFrame kfUp = new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{kvUp1, kvUp2, kvUp3, kvUp4, kvUp5, kvUp6});
        this.timelineUp.getKeyFrames().add((Object)kfUp);
    }

    public void setWidgetPaneDisable(boolean disabled) {
        if (disabled) {
            this.setDisable(true);
            this.isExpanded.set(false);
        } else {
            this.setDisable(false);
        }
    }

    private /* synthetic */ void lambda$observeMouseClicks$2(IntegerProperty clickCnt, PauseTransition clickTimer, MouseEvent event) {
        clickCnt.set(clickCnt.get() + 1);
        if (clickCnt.get() == 2) {
            this.toggleVisibility();
            clickCnt.set(0);
        }
        clickTimer.playFromStart();
    }

    private /* synthetic */ void lambda$observeMouseClicks$1(IntegerProperty clickCnt, ActionEvent event) {
        if (clickCnt.get() == 1) {
            this.oneClickBoolFlag();
        }
        clickCnt.set(0);
    }
}

