/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import org.openbase.bco.bcozy.controller.RemotePool;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.location.LocationPane;
import org.openbase.bco.bcozy.view.unitpanes.TitledPaneContainer;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class ContextMenuController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextMenuController.class);
    private final ForegroundPane foregroundPane;
    private final RemotePool remotePool;
    private final Map<String, TitledPaneContainer> titledPaneMap;

    public ContextMenuController(ForegroundPane foregroundPane, LocationPane backgroundPane, final RemotePool remotePool) {
        this.foregroundPane = foregroundPane;
        this.remotePool = remotePool;
        this.titledPaneMap = new HashMap<String, TitledPaneContainer>();
        this.foregroundPane.getMainMenu().addFillContextMenuButtonEventHandler(new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    ContextMenuController.this.setContextMenuUnitPanes("511adfec-43ed-47f5-bd4d-28f46dc1b5a4");
                }
                catch (CouldNotPerformException e) {
                    ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                }
            }
        });
        backgroundPane.addSelectedLocationIdListener((ChangeListener<? super String>)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (remotePool.isMapsFilled()) {
                    try {
                        ContextMenuController.this.setContextMenuUnitPanes(newValue);
                    }
                    catch (CouldNotPerformException e) {
                        ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                    }
                } else {
                    LOGGER.error("DALRemoteService Maps are not filled. Thus no Context Menu will be loaded!");
                }
            }
        });
    }

    public void setContextMenuUnitPanes(String locationID) throws CouldNotPerformException {
        TitledPaneContainer titledPaneContainer;
        if ("none".equals(locationID)) {
            throw new CouldNotPerformException("No location is selected.");
        }
        if (this.titledPaneMap.containsKey(locationID)) {
            titledPaneContainer = this.titledPaneMap.get(locationID);
        } else {
            titledPaneContainer = new TitledPaneContainer();
            this.fillTitledPaneContainer(titledPaneContainer, locationID);
        }
        this.foregroundPane.getContextMenu().setTitledPaneContainer(titledPaneContainer);
    }

    private void fillTitledPaneContainer(TitledPaneContainer titledPaneContainer, String locationID) {
        this.titledPaneMap.put(locationID, titledPaneContainer);
        Map<UnitTemplateType.UnitTemplate.UnitType, List<UnitRemote>> unitRemoteMap = this.remotePool.getUnitRemoteMapOfLocation(locationID);
        for (Map.Entry<UnitTemplateType.UnitTemplate.UnitType, List<UnitRemote>> nextEntry : unitRemoteMap.entrySet()) {
            try {
                titledPaneContainer.createAndAddNewTitledPane(nextEntry.getKey(), nextEntry.getValue());
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not create titledPane!", (Throwable)ex), (Logger)LOGGER);
            }
        }
        titledPaneContainer.addDummyPane();
    }

    public void clearTitledPaneMap() {
        for (Map.Entry<String, TitledPaneContainer> nextEntry : this.titledPaneMap.entrySet()) {
            nextEntry.getValue().clearTitledPane();
        }
        this.titledPaneMap.clear();
        this.foregroundPane.getContextMenu().clearVerticalScrollPane();
    }

    public void initTitledPaneMap() throws CouldNotPerformException, InterruptedException {
        try {
            for (UnitConfigType.UnitConfig locationUnitConfig : Registries.getLocationRegistry().getLocationConfigs()) {
                String locationID = locationUnitConfig.getId();
                TitledPaneContainer titledPaneContainer = new TitledPaneContainer();
                this.fillTitledPaneContainer(titledPaneContainer, locationID);
            }
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not init initTitledPaneMap!", ex), (Logger)LOGGER);
        }
    }
}

