/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javax.vecmath.Point3d;
import org.openbase.bco.bcozy.controller.RemotePool;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.location.LocationPane;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.iface.DefaultInitializable;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rct.Transform;
import rst.domotic.registry.LocationRegistryDataType;
import rst.domotic.unit.UnitConfigType;
import rst.math.Vec3DDoubleType;

public class LocationPaneController
implements DefaultInitializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocationPaneController.class);
    private final ForegroundPane foregroundPane;
    private final LocationPane locationPane;
    private final RemotePool remotePool;

    public LocationPaneController(ForegroundPane foregroundPane, LocationPane locationPane, RemotePool remotePool) {
        this.foregroundPane = foregroundPane;
        this.locationPane = locationPane;
        this.remotePool = remotePool;
        this.foregroundPane.getMainMenu().addFetchLocationButtonEventHandler((EventHandler<ActionEvent>)((EventHandler)event -> this.connectLocationRemote()));
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            Registries.getLocationRegistry().waitForData();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void connectLocationRemote() {
        try {
            Registries.getLocationRegistry().waitForData();
            Registries.getLocationRegistry().addDataObserver((Observer)new Observer<LocationRegistryDataType.LocationRegistryData>(){

                public void update(Observable<LocationRegistryDataType.LocationRegistryData> source, LocationRegistryDataType.LocationRegistryData data) throws Exception {
                    Platform.runLater(() -> {
                        try {
                            LocationPaneController.this.fetchLocations();
                            LocationPaneController.this.fetchConnections();
                            LocationPaneController.this.locationPane.updateLocationPane();
                        }
                        catch (InterruptedException | CouldNotPerformException e) {
                            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER);
                        }
                    });
                }
            });
            this.updateAndZoomFit();
        }
        catch (Exception e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
    }

    private void fetchLocations() throws CouldNotPerformException, InterruptedException {
        List locationUnitConfigList = Registries.getLocationRegistry().getLocationConfigs();
        this.locationPane.clearLocations();
        String rootLocationFrameId = Registries.getLocationRegistry().getRootLocationConfig().getPlacementConfig().getTransformationFrameId();
        for (UnitConfigType.UnitConfig locationUnitConfig : locationUnitConfigList) {
            try {
                if (locationUnitConfig.getPlacementConfig().getShape().getFloorCount() == 0) continue;
                LinkedList<Point2D> vertices = new LinkedList<Point2D>();
                Future transform = this.remotePool.getTransformReceiver().requestTransform(rootLocationFrameId, locationUnitConfig.getPlacementConfig().getTransformationFrameId(), System.currentTimeMillis());
                List shape = locationUnitConfig.getPlacementConfig().getShape().getFloorList();
                for (Vec3DDoubleType.Vec3DDouble rstVertex : shape) {
                    Point3d vertex = new Point3d(rstVertex.getX(), rstVertex.getY(), rstVertex.getZ());
                    ((Transform)transform.get(1000L, TimeUnit.MILLISECONDS)).getTransform().transform(vertex);
                    vertices.add(new Point2D(vertex.x, vertex.y));
                }
                this.locationPane.addLocation(locationUnitConfig, vertices);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                LOGGER.error("Error while fetching transformation for location \"" + locationUnitConfig.getLabel() + "\", locationID: " + locationUnitConfig.getId());
            }
        }
    }

    private void fetchConnections() throws CouldNotPerformException, InterruptedException {
        List connectionUnitConfigList = Registries.getLocationRegistry().getConnectionConfigs();
        this.locationPane.clearConnections();
        String rootLocationFrameId = Registries.getLocationRegistry().getRootLocationConfig().getPlacementConfig().getTransformationFrameId();
        for (UnitConfigType.UnitConfig connectionUnitConfig : connectionUnitConfigList) {
            try {
                if (connectionUnitConfig.getPlacementConfig().getShape().getFloorCount() == 0) continue;
                LinkedList<Point2D> vertices = new LinkedList<Point2D>();
                Future transform = this.remotePool.getTransformReceiver().requestTransform(rootLocationFrameId, connectionUnitConfig.getPlacementConfig().getTransformationFrameId(), System.currentTimeMillis());
                List shape = connectionUnitConfig.getPlacementConfig().getShape().getFloorList();
                for (Vec3DDoubleType.Vec3DDouble rstVertex : shape) {
                    Point3d vertex = new Point3d(rstVertex.getX(), rstVertex.getY(), rstVertex.getZ());
                    ((Transform)transform.get(1000L, TimeUnit.MILLISECONDS)).getTransform().transform(vertex);
                    vertices.add(new Point2D(vertex.x, vertex.y));
                }
                this.locationPane.addConnection(connectionUnitConfig, vertices);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                LOGGER.error("Error while fetching transformation for connection \"" + connectionUnitConfig.getLabel() + "\", connectionID: " + connectionUnitConfig.getId());
            }
        }
    }

    public void updateAndZoomFit() throws Exception {
        Platform.runLater(() -> {
            try {
                this.fetchLocations();
                this.fetchConnections();
                this.locationPane.updateLocationPane();
                this.locationPane.zoomFit();
            }
            catch (InterruptedException | CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER);
            }
        });
    }
}

