/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ProgressIndicator;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactory;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactoryImpl;
import org.openbase.bco.dal.remote.unit.user.UserRemote;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rct.TransformReceiver;
import rct.TransformerFactory;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

@Deprecated
public class RemotePool {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemotePool.class);
    private final Map<String, UnitRemote> unitMap;
    private final Map<String, Map<String, UnitRemote>> locationMap;
    private final Map<String, UserRemote> userMap;
    private TransformReceiver transformReceiver;
    private boolean init;
    private boolean mapsFilled;

    public RemotePool(final ForegroundPane foregroundPane) {
        foregroundPane.getMainMenu().addInitRemoteButtonEventHandler((EventHandler<ActionEvent>)((EventHandler)event -> {
            Task task = new Task(){
                private final ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);

                protected Object call() throws Exception {
                    Platform.runLater(() -> {
                        foregroundPane.getContextMenu().getTitledPaneContainer().clearTitledPane();
                        foregroundPane.getContextMenu().getChildren().add((Object)this.progressIndicator);
                    });
                    try {
                        RemotePool.this.initRegistryRemotes();
                    }
                    catch (InterruptedException | CouldNotPerformException | TransformerFactory.TransformerFactoryException e) {
                        ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                    }
                    return null;
                }

                protected void succeeded() {
                    super.succeeded();
                    Platform.runLater(() -> foregroundPane.getContextMenu().getChildren().remove((Object)this.progressIndicator));
                }
            };
            GlobalCachedExecutorService.submit((Runnable)task);
        }));
        foregroundPane.getMainMenu().addFillHashesButtonEventHandler((EventHandler<ActionEvent>)((EventHandler)event -> {
            Task task = new Task(){
                private final ProgressIndicator progressIndicator = new ProgressIndicator(-1.0);

                protected Object call() throws Exception {
                    Platform.runLater(() -> {
                        foregroundPane.getContextMenu().getTitledPaneContainer().clearTitledPane();
                        foregroundPane.getContextMenu().getChildren().add((Object)this.progressIndicator);
                    });
                    try {
                        RemotePool.this.fillUnitAndLocationMap();
                    }
                    catch (CouldNotPerformException e) {
                        ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                        RemotePool.this.shutdownDALRemotesAndClearMaps();
                    }
                    return null;
                }

                protected void succeeded() {
                    super.succeeded();
                    Platform.runLater(() -> foregroundPane.getContextMenu().getChildren().remove((Object)this.progressIndicator));
                }
            };
            GlobalCachedExecutorService.execute((Runnable)task);
        }));
        this.unitMap = new HashMap<String, UnitRemote>();
        this.locationMap = new HashMap<String, Map<String, UnitRemote>>();
        this.userMap = new HashMap<String, UserRemote>();
        this.init = false;
        this.mapsFilled = false;
    }

    public void initRegistryRemotes() throws CouldNotPerformException, InterruptedException, TransformerFactory.TransformerFactoryException {
        if (this.init) {
            LOGGER.info("INFO: RegistryRemotes were already initialized.");
            return;
        }
        Registries.waitForData();
        this.transformReceiver = TransformerFactory.getInstance().createTransformReceiver();
        this.init = true;
        LOGGER.info("INFO: RegistryRemotes are initialized.");
    }

    private void checkInit() throws CouldNotPerformException {
        if (!this.init) {
            throw new CouldNotPerformException("RegistryRemotes are not initialized.");
        }
    }

    public void fillUnitAndLocationMap() throws CouldNotPerformException, InterruptedException {
        this.checkInit();
        if (this.mapsFilled) {
            this.shutdownDALRemotesAndClearMaps();
        }
        this.fillUnitMap();
        this.fillUnitMapAgents();
        this.fillUnitMapApps();
        this.fillUnitMapScenes();
        for (UnitConfigType.UnitConfig locationUnitConfig : Registries.getLocationRegistry().getLocationConfigs()) {
            LOGGER.debug("Loading Room[" + locationUnitConfig.getId() + "] ...");
            for (String unitId : locationUnitConfig.getLocationConfig().getUnitIdList()) {
                LOGGER.debug("Loading Unit[" + unitId + "]");
                if (!this.unitMap.containsKey(unitId)) continue;
                UnitRemote currentDalRemoteService = this.unitMap.get(unitId);
                if (!this.locationMap.containsKey(locationUnitConfig.getId())) {
                    this.locationMap.put(locationUnitConfig.getId(), new TreeMap());
                }
                this.locationMap.get(locationUnitConfig.getId()).put(unitId, currentDalRemoteService);
            }
        }
        this.mapsFilled = true;
    }

    private void fillUnitMap() throws CouldNotPerformException, InterruptedException {
        UnitRemoteFactory unitRemoteFactoryInterface = UnitRemoteFactoryImpl.getInstance();
        for (UnitConfigType.UnitConfig dalUnitConfig : Registries.getUnitRegistry().getDalUnitConfigs()) {
            UnitRemote currentDalRemoteService;
            if (dalUnitConfig.getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED) {
                LOGGER.debug("Skip Unit[" + dalUnitConfig.getLabel() + "] because it is not enabled!");
                continue;
            }
            try {
                currentDalRemoteService = unitRemoteFactoryInterface.newInstance(dalUnitConfig);
            }
            catch (CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.DEBUG);
                continue;
            }
            try {
                currentDalRemoteService.init((Object)dalUnitConfig);
            }
            catch (InterruptedException | CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                continue;
            }
            try {
                currentDalRemoteService.activate();
            }
            catch (InterruptedException | CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                continue;
            }
            this.unitMap.put(dalUnitConfig.getId(), currentDalRemoteService);
        }
    }

    private void fillUnitMapAgents() throws CouldNotPerformException, InterruptedException {
        UnitRemoteFactory unitRemoteFactoryInterface = UnitRemoteFactoryImpl.getInstance();
        for (UnitConfigType.UnitConfig agentUnitConfig : Registries.getAgentRegistry().getAgentConfigs()) {
            UnitRemote currentDalRemoteService;
            if (agentUnitConfig.getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED) {
                LOGGER.debug("Skip Unit[" + agentUnitConfig.getLabel() + "] because it is not enabled!");
                continue;
            }
            try {
                currentDalRemoteService = unitRemoteFactoryInterface.newInstance(agentUnitConfig);
            }
            catch (CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                continue;
            }
            try {
                currentDalRemoteService.init((Object)agentUnitConfig);
            }
            catch (InterruptedException | CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                continue;
            }
            try {
                currentDalRemoteService.activate();
            }
            catch (InterruptedException | CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                continue;
            }
            this.unitMap.put(agentUnitConfig.getId(), currentDalRemoteService);
        }
    }

    private void fillUnitMapApps() throws CouldNotPerformException, InterruptedException {
        UnitRemoteFactory unitRemoteFactoryInterface = UnitRemoteFactoryImpl.getInstance();
        for (UnitConfigType.UnitConfig appUnitConfig : Registries.getAppRegistry().getAppConfigs()) {
            UnitRemote currentDalRemoteService;
            if (appUnitConfig.getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED) {
                LOGGER.debug("Skip Unit[" + appUnitConfig.getLabel() + "] because it is not enabled!");
                continue;
            }
            try {
                currentDalRemoteService = unitRemoteFactoryInterface.newInstance(appUnitConfig);
            }
            catch (CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                continue;
            }
            try {
                currentDalRemoteService.init((Object)appUnitConfig);
            }
            catch (InterruptedException | CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                continue;
            }
            try {
                currentDalRemoteService.activate();
            }
            catch (InterruptedException | CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                continue;
            }
            this.unitMap.put(appUnitConfig.getId(), currentDalRemoteService);
        }
    }

    private void fillUnitMapScenes() throws CouldNotPerformException, InterruptedException {
        UnitRemoteFactory unitRemoteFactoryInterface = UnitRemoteFactoryImpl.getInstance();
        for (UnitConfigType.UnitConfig sceneUnitConfig : Registries.getSceneRegistry().getSceneConfigs()) {
            UnitRemote currentDalRemoteService;
            if (sceneUnitConfig.getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED) {
                LOGGER.debug("Skip Unit[" + sceneUnitConfig.getLabel() + "] because it is not enabled!");
                continue;
            }
            try {
                currentDalRemoteService = unitRemoteFactoryInterface.newInstance(sceneUnitConfig);
            }
            catch (CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                continue;
            }
            try {
                currentDalRemoteService.init((Object)sceneUnitConfig);
            }
            catch (InterruptedException | CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                continue;
            }
            try {
                currentDalRemoteService.activate();
            }
            catch (InterruptedException | CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
                continue;
            }
            this.unitMap.put(sceneUnitConfig.getId(), currentDalRemoteService);
        }
    }

    public void fillUserMap() throws CouldNotPerformException, InterruptedException {
        for (UnitConfigType.UnitConfig currentUserUnitConfig : Registries.getUnitRegistry().getUnitConfigs(UnitTemplateType.UnitTemplate.UnitType.USER)) {
            UserRemote currentUserRemote = new UserRemote();
            try {
                currentUserRemote.init((GeneratedMessage)currentUserUnitConfig);
                currentUserRemote.activate();
            }
            catch (InterruptedException e) {
                ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            }
        }
    }

    public <Remote extends UnitRemote> Remote getUnitRemoteById(String unitId) throws CouldNotPerformException {
        this.checkInit();
        return (Remote)this.unitMap.get(unitId);
    }

    public <Remote extends UnitRemote> Remote getUnitRemoteByIdAndLocation(String unitId, String locationId) throws CouldNotPerformException {
        this.checkInit();
        return (Remote)this.locationMap.get(locationId).get(unitId);
    }

    public <Remote extends UnitRemote> List<Remote> getUnitRemoteListOfClass(Class<? extends Remote> remoteClass) throws CouldNotPerformException {
        this.checkInit();
        ArrayList<UnitRemote> unitRemoteList = new ArrayList<UnitRemote>();
        for (Map.Entry<String, UnitRemote> stringDALRemoteServiceEntry : this.unitMap.entrySet()) {
            UnitRemote currentDalRemoteService = stringDALRemoteServiceEntry.getValue();
            if (!currentDalRemoteService.getClass().equals(remoteClass)) continue;
            unitRemoteList.add(currentDalRemoteService);
        }
        return unitRemoteList;
    }

    public List<UnitRemote> getUnitRemoteListOfLocation(String locationId) throws CouldNotPerformException {
        this.checkInit();
        ArrayList<UnitRemote> unitRemoteList = new ArrayList<UnitRemote>();
        if (this.locationMap.containsKey(locationId)) {
            Map<String, UnitRemote> unitRemoteHashOfLocation = this.locationMap.get(locationId);
            for (Map.Entry<String, UnitRemote> currentEntry : unitRemoteHashOfLocation.entrySet()) {
                unitRemoteList.add(currentEntry.getValue());
            }
        }
        return unitRemoteList;
    }

    public Map<UnitTemplateType.UnitTemplate.UnitType, List<UnitRemote>> getUnitRemoteMapOfLocation(String locationId) {
        UnitTemplateType.UnitTemplate.UnitType[] unitTypes;
        if (!this.mapsFilled) {
            LOGGER.debug("MAPS not filled!");
        }
        TreeMap<UnitTemplateType.UnitTemplate.UnitType, List<UnitRemote>> unitRemoteMap = new TreeMap<UnitTemplateType.UnitTemplate.UnitType, List<UnitRemote>>();
        for (UnitTemplateType.UnitTemplate.UnitType type : unitTypes = UnitTemplateType.UnitTemplate.UnitType.values()) {
            try {
                Class remoteClass = UnitRemoteFactoryImpl.loadUnitRemoteClass((UnitTemplateType.UnitTemplate.UnitType)type);
                List unitRemoteList = this.getUnitRemoteListOfLocationAndClass(locationId, remoteClass);
                if (unitRemoteList.isEmpty()) continue;
                unitRemoteMap.put(type, unitRemoteList);
            }
            catch (CouldNotPerformException e) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Unit Type[" + type.name() + "] not supported!", (Throwable)e), (Logger)LOGGER, (LogLevel)LogLevel.DEBUG);
            }
        }
        return unitRemoteMap;
    }

    public <Remote extends UnitRemote> List<Remote> getUnitRemoteListOfLocationAndClass(String locationId, Class<? extends Remote> remoteClass) throws CouldNotPerformException {
        if (!this.mapsFilled) {
            LOGGER.debug("MAPS not filled!");
        }
        this.checkInit();
        ArrayList<UnitRemote> unitRemoteList = new ArrayList<UnitRemote>();
        if (this.locationMap.containsKey(locationId)) {
            Map<String, UnitRemote> unitRemoteHashOfLocation = this.locationMap.get(locationId);
            for (Map.Entry<String, UnitRemote> currentEntry : unitRemoteHashOfLocation.entrySet()) {
                if (currentEntry.getValue().getClass() != remoteClass) continue;
                unitRemoteList.add(currentEntry.getValue());
            }
        }
        return unitRemoteList;
    }

    public List<UserRemote> getUserRemoteList() throws CouldNotPerformException {
        this.checkInit();
        List<UserRemote> userRemoteList = this.userMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        return userRemoteList;
    }

    public void shutdownDALRemotesAndClearMaps() {
        this.shutdownDALRemotes();
        this.unitMap.clear();
        this.locationMap.clear();
        this.mapsFilled = false;
    }

    public void shutdownDALRemotes() {
        for (Map.Entry<String, UnitRemote> stringDALRemoteServiceEntry : this.unitMap.entrySet()) {
            UnitRemote remote = stringDALRemoteServiceEntry.getValue();
            remote.shutdown();
        }
    }

    public void shutdownAllRemotes() {
        for (Map.Entry<String, UnitRemote> stringDALRemoteServiceEntry : this.unitMap.entrySet()) {
            UnitRemote remote = stringDALRemoteServiceEntry.getValue();
            remote.shutdown();
        }
        TransformerFactory.killInstance();
        this.init = false;
    }

    public TransformReceiver getTransformReceiver() throws CouldNotPerformException {
        this.checkInit();
        return this.transformReceiver;
    }

    public boolean isInit() {
        return this.init;
    }

    public boolean isMapsFilled() {
        return this.mapsFilled;
    }
}

