/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import org.controlsfx.control.HiddenSidesPane;
import org.openbase.bco.bcozy.view.ContextSortingPane;
import org.openbase.bco.bcozy.view.unitpanes.TitledPaneContainer;

public class ContextMenu
extends VBox {
    private final ContextSortingPane contextSortingPane;
    private final Label roomInfo;
    private final ScrollPane verticalScrollPane;
    private TitledPaneContainer titledPaneContainer;

    public ContextMenu(double height, double width) {
        this.setMinHeight(height);
        this.setMinWidth(width);
        this.setPrefHeight(height);
        this.setMaxWidth(Double.MAX_VALUE);
        this.roomInfo = new Label("No room selected.");
        this.roomInfo.setAlignment(Pos.CENTER);
        this.verticalScrollPane = new ScrollPane();
        this.verticalScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.verticalScrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        ScrollBar scrollBar = new ScrollBar();
        scrollBar.setOrientation(Orientation.VERTICAL);
        HiddenSidesPane hiddenSidesPane = new HiddenSidesPane();
        hiddenSidesPane.setContent((Node)this.verticalScrollPane);
        hiddenSidesPane.setRight((Node)scrollBar);
        hiddenSidesPane.setTriggerDistance(200.0);
        hiddenSidesPane.getStyleClass().add((Object)"hidden-sides-pane");
        scrollBar.maxProperty().bind((ObservableValue)this.verticalScrollPane.vmaxProperty());
        scrollBar.minProperty().bind((ObservableValue)this.verticalScrollPane.vminProperty());
        this.verticalScrollPane.vvalueProperty().bindBidirectional((Property)scrollBar.valueProperty());
        this.contextSortingPane = new ContextSortingPane(width + 10.0);
        this.contextSortingPane.setMaxWidth(Double.MAX_VALUE);
        this.titledPaneContainer = new TitledPaneContainer();
        this.verticalScrollPane.setFitToWidth(true);
        this.verticalScrollPane.setContent((Node)this.titledPaneContainer);
        scrollBar.setVisibleAmount(0.25);
        this.getChildren().addAll((Object[])new Node[]{this.roomInfo, hiddenSidesPane});
        this.getStyleClass().addAll((Object[])new String[]{"detail-menu"});
    }

    public Label getRoomInfo() {
        return this.roomInfo;
    }

    public TitledPaneContainer getTitledPaneContainer() {
        return this.titledPaneContainer;
    }

    public void setTitledPaneContainer(TitledPaneContainer titledPaneContainer) {
        this.titledPaneContainer = titledPaneContainer;
        this.verticalScrollPane.setContent((Node)this.titledPaneContainer);
    }

    public void clearVerticalScrollPane() {
        this.verticalScrollPane.setContent(null);
    }
}

