/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import javafx.animation.FadeTransition;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import org.openbase.bco.bcozy.view.AnimationProvider;

public class SVGIcon
extends StackPane {
    private Text backgroundIcon;
    private Text backgroundFadeIcon;
    private Text foregroundIcon;
    private Text foregroundFadeIcon;
    private final double size;

    public SVGIcon(GlyphIcons icon, double size, boolean styled) {
        this.size = size;
        this.foregroundIcon = this.createIcon(icon, String.valueOf(size));
        this.foregroundIcon.setSmooth(true);
        this.foregroundIcon.getStyleClass().clear();
        this.foregroundFadeIcon = this.createIcon(icon, String.valueOf(size));
        this.foregroundFadeIcon.setSmooth(true);
        this.foregroundFadeIcon.getStyleClass().clear();
        this.foregroundFadeIcon.setOpacity(0.0);
        this.backgroundIcon = null;
        this.backgroundFadeIcon = null;
        if (styled) {
            this.foregroundIcon.getStyleClass().add((Object)"icons");
            this.foregroundFadeIcon.getStyleClass().add((Object)"icons");
        }
        this.getChildren().addAll((Object[])new Node[]{this.foregroundIcon, this.foregroundFadeIcon});
    }

    public SVGIcon(GlyphIcons backgroundIcon, GlyphIcons foregroundIcon, double size) {
        this.size = size;
        this.backgroundIcon = this.createIcon(backgroundIcon, String.valueOf(size));
        this.backgroundIcon.setSmooth(true);
        this.backgroundFadeIcon = this.createIcon(backgroundIcon, String.valueOf(size));
        this.backgroundFadeIcon.setSmooth(true);
        this.backgroundFadeIcon.setOpacity(0.0);
        this.foregroundIcon = this.createIcon(foregroundIcon, String.valueOf(size));
        this.foregroundIcon.setSmooth(true);
        this.foregroundIcon.getStyleClass().clear();
        this.foregroundIcon.getStyleClass().add((Object)"icons");
        this.foregroundFadeIcon = this.createIcon(foregroundIcon, String.valueOf(size));
        this.foregroundFadeIcon.setSmooth(true);
        this.foregroundFadeIcon.getStyleClass().clear();
        this.foregroundFadeIcon.getStyleClass().add((Object)"icons");
        this.foregroundFadeIcon.setOpacity(0.0);
        this.getChildren().addAll((Object[])new Node[]{this.backgroundIcon, this.backgroundFadeIcon, this.foregroundIcon, this.foregroundFadeIcon});
    }

    private Text createIcon(GlyphIcons icon, String iconSize) {
        return GlyphsDude.createIcon((GlyphIcons)icon, (String)iconSize);
    }

    public void fadeForegroundFromTransparentToOpaque() {
        FadeTransition colorFade = AnimationProvider.createFadeTransition((Node)this.foregroundIcon, 0.0, 1.0, 1, 2000.0);
        colorFade.setOnFinished(event -> this.foregroundIcon.setOpacity(1.0));
        colorFade.play();
    }

    public void fadeForegroundFromOpaqueToTransparent() {
        FadeTransition colorFade = AnimationProvider.createFadeTransition((Node)this.foregroundIcon, 1.0, 0.0, 1, 2000.0);
        colorFade.setOnFinished(event -> this.foregroundIcon.setOpacity(0.0));
        colorFade.play();
    }

    public void setBackgroundIconColorAnimated(Color color) {
        this.setAnimatedColor(this.backgroundIcon, color);
    }

    public void setForegroundIconColorAnimated(Color color) {
        this.setAnimatedColor(this.foregroundIcon, color);
    }

    public void setForegroundIconColor(Color color) {
        this.foregroundIcon.setFill((Paint)color);
        this.foregroundIcon.setStroke((Paint)Color.TRANSPARENT);
        this.foregroundIcon.setStrokeWidth(0.0);
    }

    public void setBackgroundIconColor(Color color) {
        this.backgroundIcon.setFill((Paint)color);
        this.backgroundIcon.setStroke((Paint)Color.TRANSPARENT);
        this.backgroundIcon.setStrokeWidth(0.0);
    }

    public void setForegroundIconColor(Color color, Color outline, double width) {
        this.foregroundIcon.setFill((Paint)color);
        this.foregroundIcon.setStroke((Paint)outline);
        this.foregroundIcon.setStrokeWidth(width);
    }

    private void setAnimatedColor(Text node, Color color) {
        if (node.equals(this.backgroundIcon)) {
            this.backgroundFadeIcon.setFill((Paint)color);
            FadeTransition colorFade = AnimationProvider.createFadeTransition((Node)this.backgroundFadeIcon, 0.0, 1.0, 1, 400.0);
            colorFade.setOnFinished(event -> {
                this.backgroundIcon.setFill((Paint)color);
                this.backgroundFadeIcon.setOpacity(0.0);
            });
            colorFade.play();
        } else if (node.equals(this.foregroundIcon)) {
            this.foregroundFadeIcon.setFill((Paint)color);
            FadeTransition colorFade = AnimationProvider.createFadeTransition((Node)this.foregroundFadeIcon, 0.0, 1.0, 1, 400.0);
            colorFade.setOnFinished(event -> {
                this.foregroundIcon.setFill((Paint)color);
                this.foregroundFadeIcon.setOpacity(0.0);
            });
            colorFade.play();
        }
    }

    public void changeBackgroundIcon(GlyphIcons icon) {
        this.backgroundIcon = this.createIcon(icon, String.valueOf(this.size));
        this.backgroundIcon.setSmooth(true);
        this.backgroundFadeIcon = this.createIcon(icon, String.valueOf(this.size));
        this.backgroundFadeIcon.setSmooth(true);
        this.backgroundFadeIcon.setOpacity(0.0);
        this.getChildren().clear();
        if (this.backgroundIcon == null) {
            this.getChildren().addAll((Object[])new Node[]{this.foregroundIcon, this.foregroundFadeIcon});
        } else {
            this.getChildren().addAll((Object[])new Node[]{this.backgroundIcon, this.backgroundFadeIcon, this.foregroundIcon, this.foregroundFadeIcon});
        }
    }

    public void changeForegroundIcon(GlyphIcons icon) {
        this.foregroundIcon = this.createIcon(icon, String.valueOf(this.size));
    }

    public double getSize() {
        return this.size;
    }

    public Color getForegroundIconColor() {
        return (Color)this.foregroundIcon.getFill();
    }
}

