/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import com.google.protobuf.GeneratedMessage;
import org.openbase.bco.bcozy.view.location.AbstractPolygon;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.iface.Manageable;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import rst.domotic.unit.UnitConfigType;

public abstract class AbstractUnitPolygon<M extends GeneratedMessage, UR extends UnitRemote<M>>
extends AbstractPolygon
implements Manageable<UnitConfigType.UnitConfig> {
    private UR unitRemote;
    private UnitDataObserver dataObserver = new UnitDataObserver();
    private boolean active;
    private boolean init;

    public AbstractUnitPolygon(double ... points) throws InstantiationException {
        super(points);
    }

    public void init(UnitConfigType.UnitConfig unitConfig) throws InitializationException, InterruptedException {
        try {
            this.init = true;
            this.unitRemote = (UnitRemote)Units.getUnit((UnitConfigType.UnitConfig)unitConfig, (boolean)false);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init(String unitID) throws InitializationException, InterruptedException {
        try {
            this.unitRemote = (UnitRemote)Units.getUnit((String)unitID, (boolean)false);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.active = true;
        this.unitRemote.addDataObserver((Observer)this.dataObserver);
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.active = false;
        this.unitRemote.removeDataObserver((Observer)this.dataObserver);
    }

    public boolean isActive() {
        return this.active;
    }

    public UR getUnitRemote() throws NotAvailableException {
        if (this.unitRemote == null) {
            throw new NotAvailableException("UnitRemote");
        }
        return this.unitRemote;
    }

    public String getUnitId() throws NotAvailableException {
        return (String)this.getUnitRemote().getId();
    }

    public String getLabel() throws NotAvailableException {
        return this.unitRemote.getLabel();
    }

    public abstract void applyDataUpdate(M var1);

    public class UnitDataObserver
    implements Observer<M> {
        public void update(Observable<M> source, M data) throws Exception {
            AbstractUnitPolygon.this.applyDataUpdate(data);
        }
    }
}

