/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.unitpanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.unitpanes.AbstractUnitPane;
import org.openbase.bco.bcozy.view.unitpanes.TamperDetectorPane;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.agent.AgentRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.ActivationStateType;
import rst.domotic.unit.agent.AgentDataType;

public class AgentPane
extends AbstractUnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(TamperDetectorPane.class);
    private final SVGIcon agentIcon;
    private final SVGIcon unknownForegroundIcon;
    private final SVGIcon unknownBackgroundIcon;
    private final AgentRemote agentRemote;
    private final BorderPane headContent;

    public AgentPane(UnitRemote agentRemote) {
        this.agentRemote = (AgentRemote)agentRemote;
        this.headContent = new BorderPane();
        this.agentIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.POWER, 32.0, false);
        this.unknownBackgroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE, 30.0, false);
        this.unknownForegroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE, 32.0, false);
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, true);
        this.initEffect();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.addObserverAndInitDisableState((AbstractUnitRemote)this.agentRemote);
    }

    private void initEffect() {
        ActivationStateType.ActivationState.State state = ActivationStateType.ActivationState.State.UNKNOWN;
        try {
            state = ((AgentDataType.AgentData)this.agentRemote.getData()).getActivationState().getValue();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setAgentIconAndText(state);
    }

    private void setAgentIconAndText(ActivationStateType.ActivationState.State state) {
        this.iconPane.getChildren().clear();
        if (state.equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) {
            this.agentIcon.setForegroundIconColor(Color.GREEN);
            this.iconPane.add((Node)this.agentIcon, 0, 0);
            this.observerText.setIdentifier("active");
            if (!this.toggleSwitch.isSelected()) {
                this.toggleSwitch.setSelected(true);
            }
        } else if (state.equals((Object)ActivationStateType.ActivationState.State.DEACTIVE)) {
            this.agentIcon.setForegroundIconColor(Color.BLACK);
            this.iconPane.add((Node)this.agentIcon, 0, 0);
            this.observerText.setIdentifier("inactive");
            if (this.toggleSwitch.isSelected()) {
                this.toggleSwitch.setSelected(false);
            }
        } else {
            this.iconPane.add((Node)this.unknownBackgroundIcon, 0, 0);
            this.iconPane.add((Node)this.unknownForegroundIcon, 0, 0);
            this.observerText.setIdentifier("unknown");
        }
    }

    private void sendStateToRemote(ActivationStateType.ActivationState.State state) {
        try {
            this.agentRemote.setActivationState(ActivationStateType.ActivationState.newBuilder().setValue(state).build()).get(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
    }

    @Override
    protected void initTitle() {
        this.oneClick.addListener((observable, oldValue, newValue) -> GlobalCachedExecutorService.submit((Runnable)new Task(){

            protected Object call() {
                if (AgentPane.this.toggleSwitch.isSelected()) {
                    AgentPane.this.sendStateToRemote(ActivationStateType.ActivationState.State.DEACTIVE);
                } else {
                    AgentPane.this.sendStateToRemote(ActivationStateType.ActivationState.State.ACTIVE);
                }
                return null;
            }
        }));
        this.toggleSwitch.setOnMouseClicked(event -> GlobalCachedExecutorService.submit((Runnable)new Task(){

            protected Object call() {
                if (AgentPane.this.toggleSwitch.isSelected()) {
                    AgentPane.this.sendStateToRemote(ActivationStateType.ActivationState.State.ACTIVE);
                } else {
                    AgentPane.this.sendStateToRemote(ActivationStateType.ActivationState.State.DEACTIVE);
                }
                return null;
            }
        }));
        this.unknownForegroundIcon.setForegroundIconColor(Color.BLUE);
        this.unknownBackgroundIcon.setForegroundIconColor(Color.WHITE);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(this.agentIcon.getHeight() + 10.0);
    }

    @Override
    protected void initContent() {
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = ((AgentDataType.AgentData)this.agentRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public UnitRemote getDALRemoteService() {
        return this.agentRemote;
    }

    @Override
    void removeObserver() {
        this.agentRemote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object agent) throws Exception {
        Platform.runLater(() -> {
            ActivationStateType.ActivationState.State state = ((AgentDataType.AgentData)agent).getActivationState().getValue();
            this.setAgentIconAndText(state);
        });
    }
}

