/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.unitpanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.unitpanes.AbstractUnitPane;
import org.openbase.bco.bcozy.view.unitpanes.BatteryPane;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.bco.dal.remote.unit.MotionDetectorRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.MotionStateType;
import rst.domotic.unit.dal.MotionDetectorDataType;

public class MotionDetectorPane
extends AbstractUnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatteryPane.class);
    private final MotionDetectorRemote motionDetectorRemote;
    private final SVGIcon unknownForegroundIcon;
    private final SVGIcon unknownBackgroundIcon;
    private final SVGIcon backgroundIcon;
    private final SVGIcon motionIcon;
    private final BorderPane headContent;

    public MotionDetectorPane(UnitRemote brightnessSensorRemote) {
        this.motionDetectorRemote = (MotionDetectorRemote)brightnessSensorRemote;
        this.headContent = new BorderPane();
        this.unknownBackgroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE, 30.0, false);
        this.unknownForegroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE, 32.0, false);
        this.motionIcon = new SVGIcon((GlyphIcons)MaterialIcon.BLUR_ON, (GlyphIcons)MaterialIcon.PANORAMA_FISH_EYE, 32.0);
        this.backgroundIcon = new SVGIcon((GlyphIcons)MaterialIcon.LENS, 32.0, false);
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.createWidgetPane(this.headContent, false);
        this.initEffect();
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.addObserverAndInitDisableState((AbstractUnitRemote)this.motionDetectorRemote);
    }

    private void initEffect() {
        MotionStateType.MotionState.State motionState = MotionStateType.MotionState.State.UNKNOWN;
        try {
            motionState = this.motionDetectorRemote.getMotionState().getValue();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setMotionStateIconAndTooltip(motionState);
    }

    private void setMotionStateIconAndTooltip(MotionStateType.MotionState.State motionState) {
        this.iconPane.getChildren().clear();
        if (motionState.equals((Object)MotionStateType.MotionState.State.MOTION)) {
            this.motionIcon.setBackgroundIconColorAnimated(Color.WHITE);
            this.iconPane.add((Node)this.backgroundIcon, 0, 0);
            this.iconPane.add((Node)this.motionIcon, 0, 0);
            this.observerText.setIdentifier("movement");
        } else if (motionState.equals((Object)MotionStateType.MotionState.State.NO_MOTION)) {
            this.motionIcon.setBackgroundIconColorAnimated(Color.TRANSPARENT);
            this.iconPane.add((Node)this.backgroundIcon, 0, 0);
            this.iconPane.add((Node)this.motionIcon, 0, 0);
            this.observerText.setIdentifier("noMovement");
        } else {
            this.iconPane.add((Node)this.unknownBackgroundIcon, 0, 0);
            this.iconPane.add((Node)this.unknownForegroundIcon, 0, 0);
            this.observerText.setIdentifier("unknown");
        }
    }

    @Override
    protected void initTitle() {
        this.unknownForegroundIcon.setForegroundIconColor(Color.BLUE);
        this.unknownBackgroundIcon.setForegroundIconColor(Color.WHITE);
        this.backgroundIcon.setForegroundIconColor(Color.BLACK);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.prefHeightProperty().set(this.iconPane.getHeight() + 10.0);
    }

    @Override
    protected void initContent() {
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = this.motionDetectorRemote.getLocationConfig().getLabel() + " " + ((MotionDetectorDataType.MotionDetectorData)this.motionDetectorRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public UnitRemote getDALRemoteService() {
        return this.motionDetectorRemote;
    }

    @Override
    void removeObserver() {
        this.motionDetectorRemote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object motionSensor) throws Exception {
        Platform.runLater(() -> {
            MotionStateType.MotionState.State motionState = ((MotionDetectorDataType.MotionDetectorData)motionSensor).getMotionState().getValue();
            this.setMotionStateIconAndTooltip(motionState);
        });
    }
}

