/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.unitpanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.weathericons.WeatherIcon;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.unitpanes.AbstractUnitPane;
import org.openbase.bco.bcozy.view.unitpanes.RollerShutterPane;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.bco.dal.remote.unit.TemperatureSensorRemote;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.AlarmStateType;
import rst.domotic.unit.dal.TemperatureSensorDataType;

public class TemperatureSensorPane
extends AbstractUnitPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(RollerShutterPane.class);
    private final TemperatureSensorRemote temperatureSensorRemote;
    private final BorderPane headContent;
    private final SVGIcon thermometerIconBackground;
    private final SVGIcon thermometerIconForeground;
    private final SVGIcon unknownForegroundIcon;
    private final SVGIcon unknownBackgroundIcon;
    private final SVGIcon alarmIcon;
    private final Text temperatureStatus;
    private final GridPane iconPaneAlarm;

    public TemperatureSensorPane(UnitRemote temperatureSensorRemote) {
        this.temperatureSensorRemote = (TemperatureSensorRemote)temperatureSensorRemote;
        this.thermometerIconBackground = new SVGIcon((GlyphIcons)WeatherIcon.THERMOMETER_EXTERIOR, 21.792, true);
        this.thermometerIconForeground = new SVGIcon((GlyphIcons)WeatherIcon.THERMOMETER_INTERNAL, 21.792, false);
        this.alarmIcon = new SVGIcon((GlyphIcons)FontAwesomeIcon.EXCLAMATION_TRIANGLE, 32.0, false);
        this.unknownBackgroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_BLANK_CIRCLE, 30.0, false);
        this.unknownForegroundIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.HELP_CIRCLE, 32.0, false);
        this.headContent = new BorderPane();
        this.temperatureStatus = new Text();
        this.iconPaneAlarm = new GridPane();
        this.initUnitLabel();
        this.initTitle();
        this.initContent();
        this.initEffect();
        this.createWidgetPane(this.headContent, false);
        this.tooltip.textProperty().bind((ObservableValue)this.observerText.textProperty());
        this.addObserverAndInitDisableState((AbstractUnitRemote)this.temperatureSensorRemote);
    }

    private void initEffect() {
        double temperature = Double.NEGATIVE_INFINITY;
        AlarmStateType.AlarmState.State alarmState = AlarmStateType.AlarmState.State.UNKNOWN;
        try {
            temperature = this.temperatureSensorRemote.getTemperatureState().getTemperature();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setEffectTemperature(temperature);
        try {
            alarmState = this.temperatureSensorRemote.getTemperatureAlarmState().getValue();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setAlarmStateIcon(alarmState);
    }

    private void setAlarmStateIcon(AlarmStateType.AlarmState.State alarmState) {
        this.iconPaneAlarm.getChildren().clear();
        switch (alarmState) {
            case ALARM: {
                this.iconPaneAlarm.add((Node)this.alarmIcon, 0, 0);
                this.alarmIcon.setForegroundIconColor(Color.RED, Color.BLACK, 1.5);
                this.observerText.setIdentifier("alarm");
                break;
            }
            case NO_ALARM: {
                this.iconPaneAlarm.add((Node)this.alarmIcon, 0, 0);
                this.alarmIcon.setForegroundIconColor(Color.TRANSPARENT);
                this.observerText.setIdentifier("noAlarm");
                break;
            }
            default: {
                this.iconPaneAlarm.add((Node)this.unknownBackgroundIcon, 0, 0);
                this.iconPaneAlarm.add((Node)this.unknownForegroundIcon, 0, 0);
                this.observerText.setIdentifier("unknown");
            }
        }
    }

    private void setEffectTemperature(double temperature) {
        if (temperature == Double.NEGATIVE_INFINITY) {
            this.temperatureStatus.setText("??\u00b0C");
        } else {
            this.temperatureStatus.setText((int)temperature + "\u00b0C");
            if (temperature <= 10.0) {
                this.thermometerIconForeground.setForegroundIconColorAnimated(Color.BLUE);
            } else if (temperature < 25.0) {
                double redChannel = (temperature - 10.0) / 15.0;
                double blueChannel = 1.0 - (temperature - 10.0) / 15.0;
                this.thermometerIconForeground.setForegroundIconColorAnimated(new Color(redChannel, 0.0, blueChannel, 1.0));
            } else {
                this.thermometerIconForeground.setForegroundIconColorAnimated(Color.RED);
            }
        }
    }

    @Override
    protected void initTitle() {
        this.unknownForegroundIcon.setForegroundIconColor(Color.BLUE);
        this.unknownBackgroundIcon.setForegroundIconColor(Color.WHITE);
        this.thermometerIconBackground.setForegroundIconColor(Color.BLACK);
        this.thermometerIconForeground.setForegroundIconColor(Color.RED);
        this.iconPane.add((Node)this.thermometerIconBackground, 0, 0);
        this.iconPane.add((Node)this.thermometerIconForeground, 0, 0);
        this.iconPane.add((Node)this.temperatureStatus, 1, 0);
        this.iconPane.setHgap(10.0);
        this.headContent.setLeft((Node)this.iconPane);
        this.headContent.setCenter((Node)this.getUnitLabel());
        BorderPane.setAlignment((Node)this.getUnitLabel(), (Pos)Pos.CENTER_LEFT);
        this.headContent.setRight((Node)this.iconPaneAlarm);
        this.headContent.prefHeightProperty().set(this.thermometerIconBackground.getSize() + 10.0);
    }

    @Override
    protected void initContent() {
    }

    @Override
    protected void initUnitLabel() {
        String unitLabel = "UnknownID";
        try {
            unitLabel = ((TemperatureSensorDataType.TemperatureSensorData)this.temperatureSensorRemote.getData()).getLabel();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        this.setUnitLabelString(unitLabel);
    }

    @Override
    public UnitRemote getDALRemoteService() {
        return this.temperatureSensorRemote;
    }

    @Override
    void removeObserver() {
        this.temperatureSensorRemote.removeObserver((Observer)this);
    }

    public void update(Observable observable, Object temperatureSensor) throws Exception {
        Platform.runLater(() -> {
            double temperature = ((TemperatureSensorDataType.TemperatureSensorData)temperatureSensor).getTemperatureState().getTemperature();
            this.setEffectTemperature(temperature);
            AlarmStateType.AlarmState.State alarmState = ((TemperatureSensorDataType.TemperatureSensorData)temperatureSensor).getTemperatureAlarmState().getValue();
            this.setAlarmStateIcon(alarmState);
        });
    }
}

