/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import javafx.event.ActionEvent;
import javafx.stage.Stage;
import org.openbase.bco.bcozy.view.CenterPane;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CenterPaneController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CenterPaneController.class);
    private final CenterPane centerPane;
    private State activeState = State.SETTINGS;
    private boolean isShowing = false;

    public CenterPaneController(ForegroundPane foregroundPane) {
        this.centerPane = foregroundPane.getCenterPane();
        this.centerPane.getFullscreen().setOnAction(event -> this.setMaximizeAction());
        this.centerPane.getPopUpParent().setOnAction(event -> this.setShowHidePopOver());
        this.centerPane.getPopUpChildBottom().setOnAction(event -> this.setChooseView((ActionEvent)event));
        this.centerPane.getPopUpChildTop().setOnAction(event -> this.setChooseView((ActionEvent)event));
        ((Stage)this.centerPane.getScene().getWindow()).fullScreenProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.centerPane.getFullscreen().changeIcon((GlyphIcons)MaterialIcon.FULLSCREEN);
            }
        });
    }

    private void setMaximizeAction() {
        Stage stage = (Stage)this.centerPane.getScene().getWindow();
        if (stage.isFullScreen()) {
            this.centerPane.getFullscreen().changeIcon((GlyphIcons)MaterialIcon.FULLSCREEN);
            stage.setFullScreen(false);
        } else {
            this.centerPane.getFullscreen().changeIcon((GlyphIcons)MaterialIcon.FULLSCREEN_EXIT);
            stage.setFullScreen(true);
        }
    }

    private void setShowHidePopOver() {
        if (this.isShowing) {
            this.isShowing = false;
            this.centerPane.setViewSwitchingButtonsVisible(false);
        } else {
            this.isShowing = true;
            this.centerPane.setViewSwitchingButtonsVisible(true);
        }
    }

    private void setChooseView(ActionEvent event) {
        if (event.getSource().equals((Object)this.centerPane.getPopUpChildTop())) {
            if (this.activeState.equals((Object)State.SETTINGS)) {
                this.activeState = State.MOVEMENT;
            } else if (this.activeState.equals((Object)State.MOVEMENT)) {
                this.activeState = State.TEMPERATURE;
            } else if (this.activeState.equals((Object)State.TEMPERATURE)) {
                this.activeState = State.SETTINGS;
            }
        } else if (this.activeState.equals((Object)State.SETTINGS)) {
            this.activeState = State.TEMPERATURE;
        } else if (this.activeState.equals((Object)State.MOVEMENT)) {
            this.activeState = State.SETTINGS;
        } else if (this.activeState.equals((Object)State.TEMPERATURE)) {
            this.activeState = State.MOVEMENT;
        }
        if (this.activeState.equals((Object)State.SETTINGS)) {
            this.centerPane.getPopUpParent().changeIcon((GlyphIcons)MaterialIcon.SETTINGS);
            this.centerPane.getPopUpChildBottom().changeIcon((GlyphIcons)MaterialDesignIcon.THERMOMETER_LINES);
            this.centerPane.getPopUpChildTop().changeIcon((GlyphIcons)MaterialIcon.VISIBILITY);
        } else if (this.activeState.equals((Object)State.MOVEMENT)) {
            this.centerPane.getPopUpParent().changeIcon((GlyphIcons)MaterialIcon.VISIBILITY);
            this.centerPane.getPopUpChildBottom().changeIcon((GlyphIcons)MaterialIcon.SETTINGS);
            this.centerPane.getPopUpChildTop().changeIcon((GlyphIcons)MaterialDesignIcon.THERMOMETER_LINES);
        } else if (this.activeState.equals((Object)State.TEMPERATURE)) {
            this.centerPane.getPopUpParent().changeIcon((GlyphIcons)MaterialDesignIcon.THERMOMETER_LINES);
            this.centerPane.getPopUpChildBottom().changeIcon((GlyphIcons)MaterialIcon.VISIBILITY);
            this.centerPane.getPopUpChildTop().changeIcon((GlyphIcons)MaterialIcon.SETTINGS);
        }
    }

    public static enum State {
        SETTINGS,
        TEMPERATURE,
        MOVEMENT;

    }
}

