/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import javafx.scene.layout.StackPane;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.location.LocationPane;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;

public class BackgroundPane
extends StackPane {
    private final LocationPane locationPane;
    private double prevMouseCordX;
    private double prevMouseCordY;

    public BackgroundPane(ForegroundPane foregroundPane) throws InstantiationException, InterruptedException {
        try {
            this.locationPane = LocationPane.getInstance(foregroundPane);
            this.getChildren().add((Object)this.locationPane);
            this.getStyleClass().add((Object)"background-pane");
            this.setOnMousePressed(event -> {
                this.prevMouseCordX = event.getX();
                this.prevMouseCordY = event.getY();
            });
            this.setOnMouseDragged(event -> {
                this.locationPane.setTranslateX(this.locationPane.getTranslateX() + (event.getX() - this.prevMouseCordX));
                this.locationPane.setTranslateY(this.locationPane.getTranslateY() + (event.getY() - this.prevMouseCordY));
                this.prevMouseCordX = event.getX();
                this.prevMouseCordY = event.getY();
            });
            this.setOnScroll(event -> {
                event.consume();
                if (event.getDeltaY() == 0.0) {
                    return;
                }
                double scaleFactor = event.getDeltaY() > 0.0 ? 1.05 : 0.9523809523809523;
                this.locationPane.setScaleX(this.locationPane.getScaleX() * scaleFactor);
                this.locationPane.setScaleY(this.locationPane.getScaleY() * scaleFactor);
                this.locationPane.setTranslateX(this.locationPane.getTranslateX() * scaleFactor);
                this.locationPane.setTranslateY(this.locationPane.getTranslateY() * scaleFactor);
            });
            this.setOnMouseClicked(this.locationPane.getOnEmptyAreaClickHandler());
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public LocationPane getLocationPane() {
        return this.locationPane;
    }
}

