/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.openbase.bco.bcozy.view.FloatingButton;
import org.openbase.bco.bcozy.view.ImageViewProvider;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.mainmenupanes.AvailableUsersPane;
import org.openbase.bco.bcozy.view.mainmenupanes.ConnectionPane;
import org.openbase.bco.bcozy.view.mainmenupanes.LoginPane;
import org.openbase.bco.bcozy.view.mainmenupanes.SettingsPane;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.iface.VoidInitializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainMenu
extends StackPane
implements VoidInitializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainMenu.class);
    private final LoginPane loginPane;
    private final FloatingButton mainMenuFloatingButton;
    private final VBox verticalLayout;
    private final VBox verticalLayoutSmall;
    private final double height;
    private final double width;
    private boolean maximized;
    private final ConnectionPane connectionPane;
    private final AvailableUsersPane availableUsersPane;
    private final SettingsPane settingsPane;
    private final ImageView logoView;
    private final ImageView logoViewSmall;

    public MainMenu(double height, double width) throws InterruptedException {
        this.height = height;
        this.width = width;
        this.maximized = true;
        this.setMinHeight(height);
        this.setMinWidth(width);
        this.verticalLayout = new VBox(10.0);
        this.verticalLayout.setAlignment(Pos.TOP_CENTER);
        this.verticalLayoutSmall = new VBox(20.0);
        this.verticalLayoutSmall.setAlignment(Pos.TOP_CENTER);
        this.loginPane = new LoginPane();
        this.logoView = ImageViewProvider.createImageView("/icons/bcozy.png", 175.0, Double.MAX_VALUE);
        this.logoViewSmall = ImageViewProvider.createImageView("/icons/bc.png", 48.0);
        this.connectionPane = new ConnectionPane();
        this.availableUsersPane = new AvailableUsersPane();
        this.settingsPane = new SettingsPane();
        this.mainMenuFloatingButton = new FloatingButton(new SVGIcon((GlyphIcons)MaterialIcon.MENU, 48.0, true));
        StackPane.setAlignment((Node)this.mainMenuFloatingButton, (Pos)Pos.TOP_RIGHT);
        StackPane.setAlignment((Node)this.verticalLayout, (Pos)Pos.TOP_CENTER);
        StackPane.setAlignment((Node)this.verticalLayoutSmall, (Pos)Pos.TOP_CENTER);
        this.mainMenuFloatingButton.translateYProperty().set(-85.0);
        this.verticalLayout.getChildren().addAll((Object[])new Node[]{this.logoView, this.connectionPane, this.loginPane, this.availableUsersPane, this.settingsPane});
        this.getChildren().addAll((Object[])new Node[]{this.verticalLayout, this.mainMenuFloatingButton});
        this.getStyleClass().addAll((Object[])new String[]{"main-menu"});
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            this.availableUsersPane.init();
        }
        catch (CouldNotPerformException ex) {
            new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public FloatingButton getMainMenuFloatingButton() {
        return this.mainMenuFloatingButton;
    }

    public LoginPane getLoginPane() {
        return this.loginPane;
    }

    public SettingsPane getSettingsPane() {
        return this.settingsPane;
    }

    public AvailableUsersPane getAvailableUsersPanePane() {
        return this.availableUsersPane;
    }

    public ConnectionPane getConnectionPane() {
        return this.connectionPane;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void maximizeMainMenu() {
        this.maximized = true;
        this.setMinHeight(this.height);
        this.setMinWidth(this.width);
        this.setPrefHeight(this.height);
        this.setPrefWidth(this.width);
        this.getChildren().clear();
        StackPane.setAlignment((Node)this.mainMenuFloatingButton, (Pos)Pos.TOP_RIGHT);
        this.connectionPane.maximize();
        this.mainMenuFloatingButton.translateYProperty().set(-85.0);
        this.getChildren().addAll((Object[])new Node[]{this.verticalLayout, this.mainMenuFloatingButton});
    }

    public void minimizeMainMenu() {
        this.maximized = false;
        this.setMinHeight(this.height);
        this.setPrefHeight(this.height);
        this.setMinWidth(60.0);
        StackPane.setAlignment((Node)this.mainMenuFloatingButton, (Pos)Pos.TOP_CENTER);
        this.mainMenuFloatingButton.translateYProperty().set(-85.0);
        this.verticalLayoutSmall.getChildren().clear();
        this.verticalLayoutSmall.getChildren().addAll((Object[])new Node[]{this.logoViewSmall, this.connectionPane.getStatusIcon(), this.loginPane.getStatusIcon(), this.availableUsersPane.getStatusIcon(), this.settingsPane.getStatusIcon()});
        this.getChildren().clear();
        this.getChildren().addAll((Object[])new Node[]{this.verticalLayoutSmall, this.mainMenuFloatingButton});
    }
}

