/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javafx.scene.text.Text;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserverText
extends Text
implements Observer {
    protected final Logger LOGGER = LoggerFactory.getLogger(ObserverText.class);
    private String identifier;
    private ResourceBundle languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());

    public ObserverText(String identifier) {
        this.setIdentifier(identifier);
        LanguageSelection.getInstance().addObserver(this);
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
        this.languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());
        try {
            super.setText(this.languageBundle.getString(identifier));
        }
        catch (MissingResourceException ex) {
            if (!identifier.equals("DUMMY")) {
                ExceptionPrinter.printHistory((String)("Could not resolve Identifier [" + identifier + "]!"), (Throwable)ex, (Logger)this.LOGGER, (LogLevel)LogLevel.WARN);
            }
            super.setText(identifier);
        }
    }

    @Override
    public void update(Observable observable, Object arg) {
        this.setIdentifier(this.identifier);
    }
}

