/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.generic;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.util.Duration;
import org.openbase.bco.bcozy.view.generic.WidgetPane;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;

public class ExpandableWidgedPane
extends WidgetPane {
    final Pane bodyPane;
    private final Timeline timelineUp;
    private final Timeline timelineDown;
    private boolean initialExpanded;
    private final ChangeListener<Boolean> dynamicContentChangeObserver;
    protected final BooleanProperty expansionProperty;

    public ExpandableWidgedPane(boolean initialExpanded, boolean activateable) {
        super(activateable);
        this.initialExpanded = initialExpanded;
        this.bodyPane = new HBox();
        this.timelineDown = new Timeline();
        this.dynamicContentChangeObserver = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> paramObservableValue, Boolean paramT1, Boolean expaneded) {
                try {
                    ExpandableWidgedPane.this.updateDynamicContent();
                }
                catch (Exception ex) {
                    ExceptionPrinter.printHistory((String)("Could not update all dynamic components of " + (Object)((Object)ExpandableWidgedPane.this)), (Throwable)ex, (Logger)ExpandableWidgedPane.this.LOGGER);
                }
            }
        };
        this.timelineUp = new Timeline();
        this.expansionProperty = new SimpleBooleanProperty(false);
    }

    @Override
    public void initContent() {
        super.initContent();
        this.bodyPane.getStyleClass().clear();
        this.bodyPane.getStyleClass().addAll((Object[])new String[]{"body-pane"});
        try {
            this.initBodyContent(this.bodyPane);
        }
        catch (RuntimeException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not init body content of " + (Object)((Object)this)), (Throwable)ex, (Logger)this.LOGGER);
        }
        this.animateBodyPane(this.headPane, this.bodyPane);
        this.prefHeightProperty().bind((ObservableValue)this.headPane.prefHeightProperty().add((ObservableNumberValue)this.bodyPane.prefHeightProperty()));
        this.getChildren().add((Object)this.bodyPane);
        this.expansionProperty.bindBidirectional((Property)this.secondaryActivationProperty());
        this.expansionProperty.removeListener(this.dynamicContentChangeObserver);
        this.expansionProperty.addListener(this.dynamicContentChangeObserver);
        this.expansionProperty.set(this.initialExpanded);
        this.disableProperty().addListener((observable, oldValue, disabled) -> {
            if (disabled.booleanValue()) {
                this.expansionProperty.set(false);
            }
        });
    }

    @Override
    public void updateDynamicContent() {
        super.updateDynamicContent();
        boolean expanded = this.expansionProperty.get();
        this.bodyPane.setManaged(expanded);
        this.bodyPane.setVisible(expanded);
        if (expanded) {
            this.timelineDown.play();
        } else {
            this.timelineUp.play();
        }
    }

    protected void initBodyContent(Pane bodyPane) throws CouldNotPerformException {
    }

    private void animateBodyPane(BorderPane headPane, Pane bodyPane) {
        this.timelineDown.setCycleCount(0);
        this.timelineDown.setAutoReverse(true);
        KeyValue kvDwn3 = new KeyValue((WritableValue)bodyPane.prefHeightProperty(), (Object)-1);
        KeyFrame kfDwn = new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{kvDwn3});
        this.timelineDown.getKeyFrames().add((Object)kfDwn);
        this.timelineUp.setCycleCount(1);
        this.timelineUp.setAutoReverse(true);
        KeyValue kvUp3 = new KeyValue((WritableValue)bodyPane.prefHeightProperty(), (Object)0);
        KeyFrame kfUp = new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{kvUp3});
        this.timelineUp.getKeyFrames().add((Object)kfUp);
    }

    public BooleanProperty expansionProperty() {
        return this.expansionProperty;
    }
}

