/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import javafx.collections.ObservableList;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;
import org.openbase.bco.bcozy.view.location.ConnectionPolygon;
import org.openbase.jul.exception.EnumNotSupportedException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.connection.ConnectionDataType;

public class DoorPolygon
extends ConnectionPolygon {
    private static final Logger LOGGER = LoggerFactory.getLogger(DoorPolygon.class);

    public DoorPolygon(double ... points) throws InstantiationException {
        super(points);
        ObservableList pointList = super.getPoints();
        if (this.isHorizontal()) {
            for (int i = 1; i < pointList.size(); i += 2) {
                if (((Double)pointList.get(i)).doubleValue() == this.getMinY()) {
                    pointList.set(i, (Object)(this.getMinY() - 0.5));
                    continue;
                }
                pointList.set(i, (Object)(this.getMaxY() + 0.5));
            }
        } else {
            for (int i = 0; i < pointList.size(); i += 2) {
                if (((Double)pointList.get(i)).doubleValue() == this.getMinX()) {
                    pointList.set(i, (Object)(this.getMinX() - 0.5));
                    continue;
                }
                pointList.set(i, (Object)(this.getMaxX() + 0.5));
            }
        }
    }

    @Override
    public void applyDataUpdate(ConnectionDataType.ConnectionData unitData) {
        switch (unitData.getDoorState().getValue()) {
            case CLOSED: {
                this.setCustomColor(Color.GREEN.brighter());
                break;
            }
            case IN_BETWEEN: 
            case OPEN: {
                this.setCustomColor(Color.BLUE.brighter());
                break;
            }
            case UNKNOWN: {
                this.setCustomColor(Color.YELLOW);
                break;
            }
            default: {
                ExceptionPrinter.printHistory((Throwable)new EnumNotSupportedException((Enum)unitData.getDoorState().getValue(), (Object)this), (Logger)LOGGER);
            }
        }
    }

    @Override
    protected void setConnectionStyle() {
        this.setMainColor(Color.TRANSPARENT);
        this.setStroke((Paint)Color.WHITE);
        this.getStrokeDashArray().addAll((Object[])new Double[]{2.0, 4.0});
        this.setStrokeWidth(1.0);
        this.setStrokeType(StrokeType.INSIDE);
        this.setMouseTransparent(true);
    }

    @Override
    protected void changeStyleOnOpening(boolean open) {
    }

    @Override
    protected void onColorChange(Color mainColor, Color customColor) {
        if (customColor.equals((Object)Color.TRANSPARENT)) {
            this.setFill((Paint)mainColor);
        } else {
            this.setFill((Paint)mainColor.interpolate(customColor, 0.5));
        }
    }
}

