/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import javafx.animation.FadeTransition;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.AnimationProvider;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.mainmenupanes.PaneElement;

public class ConnectionPane
extends PaneElement {
    private final SVGIcon connectionSuccessView;
    private final SVGIcon connectionProblemView;
    private final SVGIcon connectionUploadView;
    private final SVGIcon connectionDownloadView;
    private boolean test;
    private final FadeTransition problemFade;
    private final GridPane connectionIcon = new GridPane();

    public ConnectionPane() {
        SVGIcon connectionView = new SVGIcon((GlyphIcons)FontAwesomeIcon.DATABASE, 32.0, true);
        this.connectionSuccessView = new SVGIcon((GlyphIcons)FontAwesomeIcon.CHECK_CIRCLE, 16.0, true);
        this.connectionSuccessView.setOpacity(0.0);
        this.connectionProblemView = new SVGIcon((GlyphIcons)FontAwesomeIcon.QUESTION_CIRCLE, 16.0, true);
        this.connectionProblemView.setOpacity(0.0);
        this.connectionUploadView = new SVGIcon((GlyphIcons)FontAwesomeIcon.ARROW_UP, 10.0, true);
        this.connectionUploadView.setOpacity(0.0);
        this.connectionDownloadView = new SVGIcon((GlyphIcons)FontAwesomeIcon.ARROW_DOWN, 10.0, true);
        this.connectionDownloadView.setOpacity(0.0);
        this.test = false;
        connectionView.setOnMouseClicked(event -> this.testAnimations());
        this.connectionIcon.add((Node)connectionView, 0, 0, 1, 2);
        this.connectionIcon.add((Node)this.connectionSuccessView, 1, 0);
        this.connectionIcon.add((Node)this.connectionProblemView, 1, 0);
        this.connectionIcon.add((Node)this.connectionUploadView, 1, 1);
        this.connectionIcon.add((Node)this.connectionDownloadView, 1, 1);
        this.connectionIcon.setHgap(2.0);
        this.connectionIcon.setAlignment(Pos.CENTER);
        this.getChildren().addAll((Object[])new Node[]{this.connectionIcon});
        this.problemFade = AnimationProvider.createFadeTransition((Node)this.connectionProblemView, 1.0, 0.3, -1, 1000.0);
    }

    private void testAnimations() {
        if (this.test) {
            this.connectionEstablished();
            this.uploadActive();
            this.test = false;
        } else {
            this.connectionProblem();
            this.downloadActive();
            this.test = true;
        }
    }

    public void connectionEstablished() {
        this.connectionSuccessView.setOpacity(1.0);
        this.connectionSuccessView.setForegroundIconColorAnimated(Color.LIMEGREEN, 1);
        this.problemFade.stop();
        this.connectionProblemView.setOpacity(0.0);
    }

    public void connectionProblem() {
        this.connectionSuccessView.setOpacity(0.0);
        this.connectionProblemView.setForegroundIconColorAnimated(Color.TOMATO, -1);
        this.problemFade.play();
    }

    public void uploadActive() {
        this.connectionUploadView.setOpacity(1.0);
        FadeTransition uploadFade = AnimationProvider.createFadeTransition((Node)this.connectionUploadView, 0.0, 1.0, 1, 100.0);
        uploadFade.play();
        uploadFade.setOnFinished(event -> this.connectionUploadView.setOpacity(0.0));
    }

    public void downloadActive() {
        this.connectionDownloadView.setOpacity(1.0);
        FadeTransition downloadFade = AnimationProvider.createFadeTransition((Node)this.connectionDownloadView, 0.0, 1.0, 1, 100.0);
        downloadFade.play();
        downloadFade.setOnFinished(event -> this.connectionDownloadView.setOpacity(0.0));
    }

    public void maximize() {
        if (this.connectionIcon != null) {
            this.getChildren().addAll((Object[])new Node[]{this.connectionIcon});
        }
    }

    @Override
    public Node getStatusIcon() {
        return this.connectionIcon;
    }
}

