/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javafx.scene.control.TitledPane;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserverTitledPane
extends TitledPane
implements Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObserverTitledPane.class);
    private final String identifier;
    private ResourceBundle languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());

    public ObserverTitledPane(String languageString) {
        this.identifier = languageString;
        this.setTitle(languageString);
        LanguageSelection.getInstance().addObserver(this);
    }

    @Override
    public void update(Observable observable, Object arg) {
        this.languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());
        super.setText(this.languageBundle.getString(this.identifier));
    }

    public void setTitle(String languageString) {
        try {
            super.setText(this.languageBundle.getString(this.identifier));
        }
        catch (MissingResourceException ex) {
            ExceptionPrinter.printHistory((String)("Could resolve LanguageString[" + languageString + "]!"), (Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.WARN);
            super.setText(this.identifier);
        }
    }
}

