/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.user.UserRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.EnumNotSupportedException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.processing.StringProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.user.UserDataType;

public class UserPane
extends BorderPane
implements Shutdownable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserPane.class);
    private SVGIcon userIcon = new SVGIcon((GlyphIcons)MaterialIcon.PERSON, 48.0, false);
    private SVGIcon atHomeIcon = new SVGIcon((GlyphIcons)MaterialIcon.SEARCH, 16.0, true);
    private Label userNameLabel;
    private ObserverLabel userStateLabel;
    private UserRemote user;
    private final GridPane userIconPane = new GridPane();

    public UserPane() {
        this.userIconPane.setVgap(10.0);
        this.userIconPane.setHgap(10.0);
        this.userIconPane.add((Node)this.userIcon, 0, 0, 5, 5);
        this.userIconPane.add((Node)this.atHomeIcon, 4, 4, 1, 1);
        this.userNameLabel = new Label();
        this.userNameLabel.getStyleClass().add((Object)"bold-label");
        HBox nameAndGuestLayout = new HBox(10.0);
        nameAndGuestLayout.getChildren().addAll((Object[])new Node[]{this.userNameLabel});
        nameAndGuestLayout.setAlignment(Pos.CENTER);
        this.userStateLabel = new ObserverLabel("---");
        VBox nameAndStateLayout = new VBox(5.0);
        nameAndStateLayout.setAlignment(Pos.CENTER);
        nameAndStateLayout.getChildren().addAll((Object[])new Node[]{nameAndGuestLayout, this.userStateLabel});
        this.setLeft((Node)this.userIconPane);
        this.setCenter((Node)nameAndStateLayout);
    }

    public void init(UnitConfigType.UnitConfig userUniConfig) throws InitializationException, InterruptedException {
        try {
            this.user = (UserRemote)Units.getUnit((UnitConfigType.UnitConfig)userUniConfig, (boolean)false, (Class)Units.USER);
            this.user.addDataObserver((Observer)new Observer<UserDataType.UserData>(){

                public void update(Observable<UserDataType.UserData> source, UserDataType.UserData data) throws Exception {
                    Platform.runLater(() -> UserPane.this.updateDynamicComponents());
                }
            });
            this.updateDynamicComponents();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    private void updateDynamicComponents() {
        try {
            if (this.user == null || !this.user.isDataAvailable()) {
                return;
            }
            this.updateUserPresenceState();
            this.userNameLabel.setText(this.user.getName());
            this.updateBounds();
            this.userStateLabel.setText(StringProcessor.transformUpperCaseToCamelCase((String)this.user.getUserActivityState().getCurrentActivity().name()));
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)"Could not update dynamic components!", (Throwable)ex, (Logger)LOGGER);
        }
    }

    public void updateUserPresenceState() {
        try {
            switch (this.user.getUserPresenceState().getValue()) {
                case AT_HOME: 
                case SHORT_AT_HOME: 
                case SOON_AWAY: {
                    this.userIconPane.getChildren().remove((Object)this.atHomeIcon);
                    this.atHomeIcon = new SVGIcon((GlyphIcons)MaterialIcon.HOME, 16.0, true);
                    this.userIconPane.add((Node)this.atHomeIcon, 4, 4, 1, 1);
                    this.userIcon.setForegroundIconColor(Color.DODGERBLUE);
                    return;
                }
                case AWAY: 
                case SHORT_AWAY: 
                case SOON_AT_HOME: {
                    this.atHomeIcon = new SVGIcon((GlyphIcons)MaterialIcon.DIRECTIONS_WALK, 16.0, true);
                    this.userIcon.setForegroundIconColor(Color.LIGHTGRAY);
                    return;
                }
                case UNKNOWN: {
                    break;
                }
                default: {
                    ExceptionPrinter.printHistory((Throwable)new EnumNotSupportedException((Enum)this.user.getUserPresenceState().getValue(), (Object)this), (Logger)LOGGER);
                    return;
                }
            }
        }
        catch (NotAvailableException notAvailableException) {
            // empty catch block
        }
        this.atHomeIcon = new SVGIcon((GlyphIcons)MaterialIcon.SEARCH, 16.0, true);
        this.userIcon.setForegroundIconColor(Color.DARKGREY);
    }

    public void setUserState(String newUserState) {
        this.userStateLabel.setIdentifier(newUserState);
    }

    public void setUserName(String newUserName) {
        this.userNameLabel.setText(newUserName);
    }

    public void shutdown() {
    }
}

