/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.pane.unit;

import com.jfoenix.controls.JFXSlider;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.concurrent.Future;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.Constants;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.DimmableLightRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.schedule.RecurrenceEventFilter;
import org.slf4j.Logger;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.dal.DimmableLightDataType;

public class DimmableLightPane
extends AbstractUnitPane<DimmableLightRemote, DimmableLightDataType.DimmableLightData> {
    private JFXSlider brightnessSlider;
    private final RecurrenceEventFilter<Double> recurrenceEventFilterHSV = new RecurrenceEventFilter<Double>(300L){

        public void relay() {
            try {
                ((DimmableLightRemote)DimmableLightPane.this.getUnitRemote()).setBrightnessState(BrightnessStateType.BrightnessState.newBuilder().setBrightness(DimmableLightPane.this.brightnessSlider.getValue()).build());
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not send color update!", (Throwable)ex, (Logger)DimmableLightPane.this.LOGGER);
            }
        }
    };

    public DimmableLightPane() {
        super(DimmableLightRemote.class, true);
        this.setIcon((GlyphIcons)MaterialDesignIcon.LIGHTBULB_OUTLINE, (GlyphIcons)MaterialDesignIcon.LIGHTBULB);
    }

    @Override
    protected void initBodyContent(Pane bodyPane) throws CouldNotPerformException {
        this.brightnessSlider = new JFXSlider();
        this.brightnessSlider.valueProperty().addListener(observable -> {
            if (this.isHover()) {
                try {
                    this.recurrenceEventFilterHSV.trigger((Object)this.brightnessSlider.getValue());
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((String)"Could not trigger brightness change!", (Throwable)ex, (Logger)this.LOGGER);
                }
            }
        });
        bodyPane.getChildren().add((Object)this.brightnessSlider);
    }

    @Override
    public void updateDynamicContent() {
        double brightness;
        super.updateDynamicContent();
        PowerStateType.PowerState.State state = PowerStateType.PowerState.State.UNKNOWN;
        try {
            state = ((DimmableLightDataType.DimmableLightData)((DimmableLightRemote)this.getUnitRemote()).getData()).getPowerState().getValue();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)this.LOGGER, (LogLevel)LogLevel.DEBUG);
        }
        try {
            brightness = ((DimmableLightDataType.DimmableLightData)this.getData()).getBrightnessState().getBrightness();
        }
        catch (CouldNotPerformException e) {
            brightness = 100.0;
            ExceptionPrinter.printHistory((Throwable)e, (Logger)this.LOGGER, (LogLevel)LogLevel.DEBUG);
        }
        if (this.brightnessSlider != null && !this.isHover()) {
            this.brightnessSlider.setValue(brightness);
        }
        switch (state) {
            case OFF: {
                this.getIcon().setBackgroundIconColor(Constants.LIGHTBULB_OFF_COLOR);
                this.setInfoText("lightOff");
                this.setPrimaryActivationWithoutNotification(Boolean.FALSE);
                break;
            }
            case ON: {
                this.getIcon().setBackgroundIconColor(Constants.LIGHTBULB_OFF_COLOR.interpolate(Color.CORNSILK, brightness / 100.0));
                this.setInfoText("lightOn");
                this.setPrimaryActivationWithoutNotification(Boolean.TRUE);
                break;
            }
            default: {
                this.setInfoText("unknown");
            }
        }
    }

    @Override
    protected Future applyPrimaryActivationUpdate(boolean activation) throws CouldNotPerformException {
        return activation ? ((DimmableLightRemote)this.getUnitRemote()).setPowerState(PowerStateType.PowerState.State.ON) : ((DimmableLightRemote)this.getUnitRemote()).setPowerState(PowerStateType.PowerState.State.OFF);
    }
}

