/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.pane.unit;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.TamperDetectorRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import rst.domotic.state.TamperStateType;
import rst.domotic.unit.dal.TamperDetectorDataType;

public class TamperDetectorPane
extends AbstractUnitPane<TamperDetectorRemote, TamperDetectorDataType.TamperDetectorData> {
    public TamperDetectorPane() {
        super(TamperDetectorRemote.class, false);
        this.getIcon().setForegroundIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_MARKED_CIRCLE_OUTLINE);
    }

    @Override
    public void updateDynamicContent() {
        super.updateDynamicContent();
        TamperStateType.TamperState.State state = TamperStateType.TamperState.State.UNKNOWN;
        try {
            state = ((TamperDetectorDataType.TamperDetectorData)((TamperDetectorRemote)this.getUnitRemote()).getData()).getTamperState().getValue();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)this.LOGGER, (LogLevel)LogLevel.DEBUG);
        }
        switch (state) {
            case NO_TAMPER: {
                this.getIcon().setForegroundIcon((GlyphIcons)MaterialDesignIcon.CHECKBOX_MARKED_CIRCLE_OUTLINE);
                this.setInfoText("noTamper");
                break;
            }
            case TAMPER: {
                this.getIcon().setForegroundIcon((GlyphIcons)MaterialDesignIcon.ALERT_CIRCLE, Color.RED);
                this.getIcon().startForgroundAnimation(-1);
                this.setInfoText("tamper");
                break;
            }
            default: {
                this.setInfoText("unknown");
            }
        }
    }
}

