/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.pane.unit.scene;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.concurrent.Future;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.scene.SceneRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import rst.domotic.state.ActivationStateType;
import rst.domotic.unit.scene.SceneDataType;

public class ScenePane
extends AbstractUnitPane<SceneRemote, SceneDataType.SceneData> {
    public ScenePane() {
        super(SceneRemote.class, true);
        this.getIcon().setForegroundIcon((GlyphIcons)MaterialDesignIcon.VECTOR_COMBINE);
    }

    @Override
    public void updateDynamicContent() {
        super.updateDynamicContent();
        ActivationStateType.ActivationState.State state = ActivationStateType.ActivationState.State.UNKNOWN;
        try {
            state = ((SceneDataType.SceneData)((SceneRemote)this.getUnitRemote()).getData()).getActivationState().getValue();
        }
        catch (CouldNotPerformException e) {
            ExceptionPrinter.printHistory((Throwable)e, (Logger)this.LOGGER, (LogLevel)LogLevel.DEBUG);
        }
        switch (state) {
            case ACTIVE: {
                this.getIcon().setForegroundIconColor(Color.GREEN);
                this.setPrimaryActivationWithoutNotification(Boolean.TRUE);
                break;
            }
            case DEACTIVE: {
                this.getIcon().setForegroundIconColor(Color.BLACK);
                this.setPrimaryActivationWithoutNotification(Boolean.FALSE);
            }
        }
    }

    @Override
    protected Future applyPrimaryActivationUpdate(boolean activation) throws CouldNotPerformException {
        return activation ? ((SceneRemote)this.getUnitRemote()).setActivationState(ActivationStateType.ActivationState.State.ACTIVE) : ((SceneRemote)this.getUnitRemote()).setActivationState(ActivationStateType.ActivationState.State.DEACTIVE);
    }
}

