/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import com.jfoenix.controls.JFXCheckBox;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;
import org.controlsfx.control.CheckComboBox;
import org.openbase.bco.bcozy.model.SessionManagerFacade;
import org.openbase.bco.bcozy.model.SessionManagerFacadeImpl;
import org.openbase.bco.bcozy.util.Groups;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class RegistrationController {
    private static final Logger logger = LoggerFactory.getLogger(RegistrationController.class);
    private SessionManagerFacade sessionManager = new SessionManagerFacadeImpl();
    @FXML
    private Pane root;
    @FXML
    private PasswordField passwordField;
    @FXML
    private PasswordField repeatPasswordField;
    @FXML
    private TextField username;
    @FXML
    private TextField firstname;
    @FXML
    private TextField lastname;
    @FXML
    private TextField mail;
    @FXML
    private TextField phone;
    @FXML
    private CheckComboBox<UnitConfigType.UnitConfig> usergroupField;
    @FXML
    private JFXCheckBox isAdmin;
    @FXML
    private Button registerBtn;

    public void initialize() {
        ObservableList<UnitConfigType.UnitConfig> groups = Groups.getGroups();
        groups.addListener(c -> this.setGroups(groups));
        this.registerBtn.getStyleClass().clear();
        this.registerBtn.getStyleClass().add((Object)"transparent-button");
        this.registerBtn.setText(this.registerBtn.getText().toUpperCase());
        this.usergroupField.setConverter(Groups.stringConverter(groups));
        this.usergroupField.prefWidthProperty().bind((ObservableValue)this.root.widthProperty());
    }

    private void setGroups(ObservableList<UnitConfigType.UnitConfig> groups) {
        Platform.runLater(() -> this.usergroupField.getItems().setAll((Collection)groups));
    }

    @FXML
    private void register() throws InterruptedException {
        this.resetHints();
        if (!this.sessionManager.isAdmin()) {
            return;
        }
        try {
            this.sessionManager.verifyUserName(this.username.getText());
        }
        catch (VerificationFailedException ex) {
            this.username.getStyleClass().add((Object)"text-field-wrong");
            return;
        }
        try {
            this.sessionManager.verifyPasswords(this.passwordField.getText(), this.repeatPasswordField.getText());
        }
        catch (VerificationFailedException ex) {
            this.passwordField.getStyleClass().add((Object)"password-field-wrong");
            this.repeatPasswordField.getStyleClass().add((Object)"password-field-wrong");
            return;
        }
        try {
            this.sessionManager.verifyPhoneNumber(this.phone.getText());
        }
        catch (VerificationFailedException ex) {
            this.phone.getStyleClass().add((Object)"text-field-wrong");
            return;
        }
        try {
            this.sessionManager.verifyMailAddress(this.mail.getText());
        }
        catch (VerificationFailedException ex) {
            this.mail.getStyleClass().add((Object)"text-field-wrong");
            return;
        }
        ObservableList groups = this.usergroupField.getCheckModel().getCheckedItems();
        try {
            this.sessionManager.registerUser(new SessionManagerFacade.NewUser(this.username.getText(), this.firstname.getText(), this.lastname.getText(), this.mail.getText(), this.phone.getText()), this.passwordField.getText(), this.isAdmin.isSelected(), (List<UnitConfigType.UnitConfig>)groups);
            this.resetFields();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)logger);
        }
    }

    private void resetHints() {
        this.username.getStyleClass().removeAll((Object[])new String[]{"text-field-wrong"});
        this.passwordField.getStyleClass().removeAll((Object[])new String[]{"password-field-wrong"});
        this.repeatPasswordField.getStyleClass().removeAll((Object[])new String[]{"password-field-wrong"});
    }

    private void resetFields() {
        this.username.setText("");
        this.firstname.setText("");
        this.lastname.setText("");
        this.mail.setText("");
        this.phone.setText("");
        this.passwordField.setText("");
        this.repeatPasswordField.setText("");
        this.isAdmin.setSelected(false);
        this.usergroupField.getCheckModel().clearChecks();
    }

    public Pane getRoot() {
        return this.root;
    }

    class SessionManagerFacadeFake
    implements SessionManagerFacade {
        SessionManagerFacadeFake() {
        }

        @Override
        public boolean isAdmin() {
            return true;
        }

        @Override
        public void registerUser(SessionManagerFacade.NewUser user, String plainPassword, boolean asAdmin, List<UnitConfigType.UnitConfig> groups) throws CouldNotPerformException {
            StringConverter<UnitConfigType.UnitConfig> converter = Groups.stringConverter(groups);
            System.out.print("username = [" + user.getUsername() + "], plainPassword = [" + plainPassword + "], asAdmin = [" + asAdmin + "], groups = [");
            groups.forEach(g -> System.out.print(converter.toString(g)));
            System.out.println("]");
        }

        @Override
        public void verifyUserName(String username) throws VerificationFailedException {
            if (username.isEmpty()) {
                throw new VerificationFailedException("user name is empty!");
            }
        }

        @Override
        public void verifyPasswords(String text, String text1) throws VerificationFailedException {
            if (text.isEmpty() && text.equals(text1)) {
                throw new VerificationFailedException("repeated password does not match!");
            }
        }

        @Override
        public void verifyPhoneNumber(String phoneNumber) throws VerificationFailedException {
        }

        @Override
        public void verifyMailAddress(String mailAddress) throws VerificationFailedException {
        }
    }
}

