/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import org.openbase.bco.bcozy.BCozy;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoPane
extends BorderPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoPane.class);
    private static InfoPane instance;
    private final ObserverLabel textLabel = new ObserverLabel();

    public InfoPane(double height, double width) {
        this.textLabel.getStyleClass().add((Object)"floating-label");
        this.textLabel.setAlignment(Pos.CENTER);
        this.setCenter((Node)this.textLabel);
        this.setPrefHeight(height);
        this.setPrefWidth(width);
        instance = this;
    }

    public static InfoPane getInstance() throws NotAvailableException {
        if (instance == null) {
            throw new NotAvailableException("InfoPane", (Throwable)new InvalidStateException("InfoPane not initialized!"));
        }
        return instance;
    }

    @Deprecated
    public Label getMouseOverText() {
        return this.textLabel;
    }

    public static void info(String identifier) {
        assert (identifier != null);
        try {
            ObserverLabel textLabel = InfoPane.getInstance().textLabel;
            Platform.runLater(() -> {
                if (BCozy.baseColorIsWhite) {
                    textLabel.setStyle("-fx-text-fill: white; -fx-font-size: 16;");
                } else {
                    textLabel.setStyle("-fx-text-fill: black; -fx-font-size: 16;");
                }
                textLabel.setIdentifier(identifier);
            });
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)"Could not print user feedback!", (Throwable)ex, (Logger)LOGGER);
        }
    }

    public static void confirmation(String identifier) {
        assert (identifier != null);
        try {
            ObserverLabel textLabel = InfoPane.getInstance().textLabel;
            Platform.runLater(() -> {
                textLabel.setStyle("-fx-text-fill: green; -fx-font-size: 16;");
                textLabel.setIdentifier(identifier);
            });
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)"Could not print user feedback!", (Throwable)ex, (Logger)LOGGER);
        }
    }

    public static void warn(String identifier) {
        assert (identifier != null);
        try {
            ObserverLabel textLabel = InfoPane.getInstance().textLabel;
            Platform.runLater(() -> {
                textLabel.setStyle("-fx-text-fill: orange; -fx-font-size: 16;");
                textLabel.setIdentifier(identifier);
            });
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)"Could not print user feedback!", (Throwable)ex, (Logger)LOGGER);
        }
    }

    public static void error(String identifier) {
        assert (identifier != null);
        try {
            ObserverLabel textLabel = InfoPane.getInstance().textLabel;
            Platform.runLater(() -> {
                textLabel.setStyle("-fx-text-fill: red; -fx-font-size: 16;");
                textLabel.setIdentifier(identifier);
            });
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)"Could not print user feedback!", (Throwable)ex, (Logger)LOGGER);
        }
    }
}

