/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import javafx.collections.ObservableList;
import org.openbase.bco.bcozy.view.location.AbstractUnitPolygon;
import org.openbase.bco.dal.remote.unit.connection.ConnectionRemote;
import org.openbase.jul.exception.InstantiationException;
import rst.domotic.unit.connection.ConnectionDataType;

public abstract class ConnectionPolygon
extends AbstractUnitPolygon<ConnectionDataType.ConnectionData, ConnectionRemote> {
    private boolean open = false;
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;
    private final boolean horizontal;

    public ConnectionPolygon(double ... points) throws InstantiationException {
        super(points);
        int i;
        ObservableList pointList = super.getPoints();
        double tempMinX = Double.MAX_VALUE;
        double tempMaxX = Double.MIN_VALUE;
        double tempMinY = Double.MAX_VALUE;
        double tempMaxY = Double.MIN_VALUE;
        for (i = 0; i < pointList.size(); i += 2) {
            tempMinX = (Double)pointList.get(i) < tempMinX ? (Double)pointList.get(i) : tempMinX;
            tempMaxX = (Double)pointList.get(i) > tempMaxX ? (Double)pointList.get(i) : tempMaxX;
        }
        for (i = 1; i < pointList.size(); i += 2) {
            tempMinY = (Double)pointList.get(i) < tempMinY ? (Double)pointList.get(i) : tempMinY;
            tempMaxY = (Double)pointList.get(i) > tempMaxY ? (Double)pointList.get(i) : tempMaxY;
        }
        this.minX = tempMinX;
        this.maxX = tempMaxX;
        this.minY = tempMinY;
        this.maxY = tempMaxY;
        this.horizontal = this.maxX - this.minX > this.maxY - this.minY;
        this.setConnectionStyle();
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
        this.changeStyleOnOpening(open);
    }

    protected double getMinX() {
        return this.minX;
    }

    protected double getMaxX() {
        return this.maxX;
    }

    protected double getMinY() {
        return this.minY;
    }

    protected double getMaxY() {
        return this.maxY;
    }

    protected boolean isHorizontal() {
        return this.horizontal;
    }

    protected abstract void changeStyleOnOpening(boolean var1);

    protected abstract void setConnectionStyle();
}

