/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.ParallelTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.TranslateTransition;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Shape;
import javafx.util.Duration;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.bco.bcozy.view.location.ConnectionPolygon;
import org.openbase.bco.bcozy.view.location.DoorPolygon;
import org.openbase.bco.bcozy.view.location.LocationPolygon;
import org.openbase.bco.bcozy.view.location.PassagePolygon;
import org.openbase.bco.bcozy.view.location.RegionPolygon;
import org.openbase.bco.bcozy.view.location.TilePolygon;
import org.openbase.bco.bcozy.view.location.WindowPolygon;
import org.openbase.bco.bcozy.view.location.ZonePolygon;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.EnumNotSupportedException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public final class LocationPane
extends Pane {
    private static LocationPane instance;
    private static boolean initialized;
    private static final Logger LOGGER;
    private LocationPolygon selectedLocation;
    private ZonePolygon rootRoom;
    private final ForegroundPane foregroundPane;
    private final Map<String, TilePolygon> tileMap;
    private final Map<String, RegionPolygon> regionMap;
    private final Map<String, ConnectionPolygon> connectionMap;
    public final SimpleStringProperty selectedLocationId;
    private LocationPolygon lastFirstClickTarget;
    private LocationPolygon lastSelectedTile;
    private final EventHandler<MouseEvent> onEmptyAreaClickHandler;

    private LocationPane(ForegroundPane foregroundPane) throws InstantiationException, InterruptedException {
        this.foregroundPane = foregroundPane;
        this.tileMap = new HashMap<String, TilePolygon>();
        this.regionMap = new HashMap<String, RegionPolygon>();
        this.connectionMap = new HashMap<String, ConnectionPolygon>();
        this.selectedLocationId = new SimpleStringProperty("DUMMY");
        this.rootRoom = null;
        this.onEmptyAreaClickHandler = event -> {
            if (event.isStillSincePress() && this.rootRoom != null) {
                try {
                    if (event.getClickCount() == 1) {
                        if (!this.rootRoom.equals(this.selectedLocation)) {
                            if (this.selectedLocation != null) {
                                this.selectedLocation.setSelected(false);
                            }
                            this.rootRoom.setSelected(true);
                            this.setSelectedLocation(this.rootRoom);
                        }
                    } else if (event.getClickCount() == 2) {
                        this.autoFocusPolygonAnimated(this.rootRoom);
                    }
                    try {
                        foregroundPane.getContextMenu().getRoomInfo().setText(this.selectedLocation.getLabel());
                    }
                    catch (NotAvailableException ex) {
                        LOGGER.warn("Could not resolve location label!", (Throwable)ex);
                    }
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((String)"Could not handle mouse event!", (Throwable)ex, (Logger)LOGGER);
                }
            }
        };
        this.heightProperty().addListener((observable, oldValue, newValue) -> this.setTranslateY(this.getTranslateY() - (oldValue.doubleValue() - newValue.doubleValue()) / 2.0 * this.getScaleY()));
        this.widthProperty().addListener((observable, oldValue, newValue) -> this.setTranslateX(this.getTranslateX() - (oldValue.doubleValue() - newValue.doubleValue()) / 2.0 * this.getScaleX()));
        this.foregroundPane.getMainMenuWidthProperty().addListener((observable, oldValue, newValue) -> this.setTranslateX(this.getTranslateX() - (oldValue.doubleValue() - newValue.doubleValue()) / 2.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocationPane getInstance() throws java.lang.InstantiationException {
        Class<LocationPane> clazz = LocationPane.class;
        synchronized (LocationPane.class) {
            if (instance == null) {
                throw new java.lang.InstantiationException();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setInitialized(boolean init) {
        initialized = init;
    }

    public boolean isInitialized() {
        return initialized;
    }

    public ForegroundPane getForeground() {
        return this.foregroundPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocationPane getInstance(ForegroundPane foregroundPane) throws InstantiationException, InterruptedException {
        Class<LocationPane> clazz = LocationPane.class;
        synchronized (LocationPane.class) {
            if (instance == null) {
                instance = new LocationPane(foregroundPane);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void addLocation(UnitConfigType.UnitConfig locationUnitConfig, List<Point2D> vertices) throws CouldNotPerformException, InterruptedException {
        try {
            double[] points = new double[vertices.size() * 2];
            for (int i = 0; i < vertices.size(); ++i) {
                points[i * 2] = vertices.get(i).getY() * 50.0;
                points[i * 2 + 1] = vertices.get(i).getX() * 50.0;
            }
            switch (locationUnitConfig.getLocationConfig().getType()) {
                case TILE: {
                    TilePolygon locationPolygon = new TilePolygon(points);
                    locationPolygon.init(locationUnitConfig);
                    locationPolygon.activate();
                    this.addMouseEventHandlerToTile(locationPolygon);
                    this.tileMap.put(locationUnitConfig.getId(), locationPolygon);
                    break;
                }
                case REGION: {
                    RegionPolygon locationPolygon = new RegionPolygon(points);
                    locationPolygon.init(locationUnitConfig);
                    locationPolygon.activate();
                    this.addMouseEventHandlerToRegion(locationPolygon);
                    this.regionMap.put(locationUnitConfig.getId(), locationPolygon);
                    break;
                }
                case ZONE: {
                    ZonePolygon locationPolygon = new ZonePolygon(points);
                    locationPolygon.init(locationUnitConfig);
                    locationPolygon.activate();
                    this.rootRoom = locationPolygon;
                    break;
                }
                default: {
                    throw new EnumNotSupportedException((Enum)locationUnitConfig.getLocationConfig().getType(), (Object)this);
                }
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not add location!", (Throwable)ex);
        }
    }

    public void addConnection(UnitConfigType.UnitConfig connectionUnitConfig, List<Point2D> vertices) throws CouldNotPerformException, InterruptedException {
        try {
            ConnectionPolygon connectionPolygon;
            double[] points = new double[vertices.size() * 2];
            for (int i = 0; i < vertices.size(); ++i) {
                points[i * 2] = vertices.get(i).getY() * 50.0;
                points[i * 2 + 1] = vertices.get(i).getX() * 50.0;
            }
            switch (connectionUnitConfig.getConnectionConfig().getType()) {
                case DOOR: {
                    connectionPolygon = new DoorPolygon(points);
                    break;
                }
                case WINDOW: {
                    connectionPolygon = new WindowPolygon(points);
                    break;
                }
                case PASSAGE: {
                    connectionPolygon = new PassagePolygon(points);
                    break;
                }
                default: {
                    throw new EnumNotSupportedException((Enum)connectionUnitConfig.getConnectionConfig().getType(), (Object)this);
                }
            }
            connectionPolygon.init(connectionUnitConfig);
            connectionPolygon.activate();
            this.connectionMap.put(connectionUnitConfig.getId(), connectionPolygon);
            connectionUnitConfig.getConnectionConfig().getTileIdList().forEach(locationId -> {
                if (this.tileMap.containsKey(locationId)) {
                    this.tileMap.get(locationId).addCuttingShape((Shape)connectionPolygon);
                } else {
                    String unitLabel = locationId;
                    try {
                        unitLabel = Registries.getUnitRegistry((boolean)false).getUnitConfigById(locationId).getLabel();
                    }
                    catch (InterruptedException | CouldNotPerformException throwable) {
                        // empty catch block
                    }
                    LOGGER.warn("Location " + unitLabel + " can not be found in the location Map. No Cutting will be applied.");
                }
            });
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not add connection!", (Throwable)ex);
        }
    }

    public void clearLocations() {
        this.tileMap.forEach((locationId, locationPolygon) -> {
            locationPolygon.shutdown();
            this.getChildren().remove(locationPolygon);
        });
        this.tileMap.clear();
        this.regionMap.forEach((locationId, locationPolygon) -> {
            locationPolygon.shutdown();
            this.getChildren().remove(locationPolygon);
        });
        this.regionMap.clear();
        this.rootRoom = null;
    }

    public void clearConnections() {
        this.connectionMap.forEach((connectionId, connectionPolygon) -> {
            connectionPolygon.shutdown();
            this.getChildren().remove(connectionPolygon);
        });
        this.connectionMap.clear();
    }

    public void updateLocationPane() {
        this.getChildren().clear();
        this.tileMap.forEach((locationId, locationPolygon) -> {
            if (this.rootRoom != null) {
                this.rootRoom.addCuttingShape((Shape)locationPolygon);
            }
            this.getChildren().add(locationPolygon);
        });
        this.regionMap.forEach((locationId, locationPolygon) -> {
            if (this.rootRoom != null) {
                this.rootRoom.addCuttingShape((Shape)locationPolygon);
            }
            this.getChildren().add(locationPolygon);
        });
        this.connectionMap.forEach((connectionId, connectionPolygon) -> {
            if (this.rootRoom != null) {
                this.rootRoom.addCuttingShape((Shape)connectionPolygon);
            }
            this.getChildren().add(connectionPolygon);
        });
        if (this.rootRoom != null) {
            this.getChildren().add((Object)this.rootRoom);
        }
    }

    public void addMouseEventHandlerToTile(TilePolygon tile) {
        tile.setOnMouseClicked(event -> {
            try {
                event.consume();
                if (event.isStillSincePress()) {
                    if (event.getClickCount() == 1) {
                        this.setSelectedLocation(tile);
                        this.lastFirstClickTarget = tile;
                    } else if (event.getClickCount() == 2) {
                        this.autoFocusPolygonAnimated(tile);
                    }
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not handle mouse event!", (Throwable)ex, (Logger)LOGGER);
            }
        });
        tile.setOnMouseEntered(event -> {
            event.consume();
            tile.mouseEntered();
            try {
                InfoPane.info(tile.getLabel());
            }
            catch (NotAvailableException ex) {
                LOGGER.warn("Could not resolve location label!", (Throwable)ex);
            }
        });
        tile.setOnMouseExited(event -> {
            event.consume();
            tile.mouseLeft();
            InfoPane.info("");
        });
    }

    public void addMouseEventHandlerToRegion(RegionPolygon region) {
        region.setOnMouseClicked(event -> {
            try {
                event.consume();
                if (event.isStillSincePress()) {
                    if (event.getClickCount() == 1) {
                        this.setSelectedLocation(region);
                        this.lastFirstClickTarget = region;
                    } else if (event.getClickCount() == 2) {
                        if (this.lastFirstClickTarget.equals(region)) {
                            this.autoFocusPolygonAnimated(region);
                        } else {
                            this.selectedLocation.fireEvent((Event)event.copyFor(null, (EventTarget)this.selectedLocation));
                        }
                    }
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not handle mouse event!", (Throwable)ex, (Logger)LOGGER);
            }
        });
        region.setOnMouseEntered(event -> {
            try {
                event.consume();
                region.mouseEntered();
                InfoPane.info(region.getLabel());
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not handle mouse event!", (Throwable)ex, (Logger)LOGGER);
            }
        });
        region.setOnMouseExited(event -> {
            event.consume();
            region.mouseLeft();
            InfoPane.info("");
        });
    }

    private void setSelectedLocation(LocationPolygon newSelectedLocation) throws CouldNotPerformException {
        try {
            if (this.selectedLocation != null && this.selectedLocation.equals(newSelectedLocation)) {
                return;
            }
            if (this.lastSelectedTile != null) {
                if (!newSelectedLocation.getClass().equals(RegionPolygon.class)) {
                    this.lastSelectedTile.getChildIds().forEach(childId -> {
                        try {
                            if (this.regionMap.containsKey(childId)) {
                                this.regionMap.get(childId).changeStyleOnSelectable(false);
                            }
                        }
                        catch (Exception ex) {
                            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
                        }
                    });
                }
                if (newSelectedLocation.getClass().equals(TilePolygon.class)) {
                    this.lastSelectedTile = newSelectedLocation;
                    newSelectedLocation.getChildIds().forEach(childId -> {
                        try {
                            this.regionMap.get(childId).changeStyleOnSelectable(true);
                        }
                        catch (Exception ex) {
                            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
                        }
                    });
                }
            }
            if (this.selectedLocation != null) {
                this.selectedLocation.setSelected(false);
            }
            newSelectedLocation.setSelected(true);
            this.selectedLocation = newSelectedLocation;
            this.selectedLocationId.set(newSelectedLocation.getUnitId());
            this.foregroundPane.getContextMenu().getRoomInfo().setText(this.selectedLocation.getLabel());
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not select location polygon!", (Throwable)ex);
        }
    }

    public void zoomFit() {
        if (this.rootRoom != null) {
            this.autoFocusPolygon(this.rootRoom);
        } else if (!this.tileMap.isEmpty()) {
            this.autoFocusPolygon(this.tileMap.values().iterator().next());
        }
    }

    public void addSelectedLocationIdListener(ChangeListener<? super String> changeListener) {
        this.selectedLocationId.addListener(changeListener);
    }

    public void removeSelectedLocationIdListener(ChangeListener<? super String> changeListener) {
        this.selectedLocationId.removeListener(changeListener);
        this.selectedLocationId.set("home");
    }

    public EventHandler<MouseEvent> getOnEmptyAreaClickHandler() {
        return this.onEmptyAreaClickHandler;
    }

    private void autoFocusPolygon(LocationPolygon polygon) {
        double yScale;
        double xScale = this.foregroundPane.getBoundingBox().getWidth() / polygon.prefWidth(0.0) * 0.7;
        double scale = xScale < (yScale = this.foregroundPane.getBoundingBox().getHeight() / polygon.prefHeight(0.0) * 0.7) ? xScale : yScale;
        this.setScaleX(scale);
        this.setScaleY(scale);
        Point2D transition = this.calculateTransition(scale, polygon);
        this.setTranslateX(transition.getX());
        this.setTranslateY(transition.getY());
    }

    private void autoFocusPolygonAnimated(LocationPolygon polygon) {
        double yScale;
        double xScale = this.foregroundPane.getBoundingBox().getWidth() / polygon.prefWidth(0.0) * 0.7;
        double scale = xScale < (yScale = this.foregroundPane.getBoundingBox().getHeight() / polygon.prefHeight(0.0) * 0.7) ? xScale : yScale;
        ScaleTransition scaleTransition = new ScaleTransition(Duration.millis((double)500.0));
        scaleTransition.setToX(scale);
        scaleTransition.setToY(scale);
        scaleTransition.setCycleCount(1);
        scaleTransition.setAutoReverse(true);
        Point2D transition = this.calculateTransition(scale, polygon);
        TranslateTransition translateTransition = new TranslateTransition(Duration.millis((double)500.0));
        translateTransition.setToX(transition.getX());
        translateTransition.setToY(transition.getY());
        translateTransition.setCycleCount(1);
        translateTransition.setAutoReverse(true);
        ParallelTransition parallelTransition = new ParallelTransition((Node)this, new Animation[]{scaleTransition, translateTransition});
        parallelTransition.play();
    }

    private Point2D calculateTransition(double scale, LocationPolygon polygon) {
        double polygonDistanceToCenterX = -(polygon.getCenterX() - this.getLayoutBounds().getWidth() / 2.0) * scale;
        double polygonDistanceToCenterY = -(polygon.getCenterY() - this.getLayoutBounds().getHeight() / 2.0) * scale;
        double boundingBoxCenterX = (this.foregroundPane.getBoundingBox().getMinX() + this.foregroundPane.getBoundingBox().getMaxX()) / 2.0;
        double boundingBoxCenterY = (this.foregroundPane.getBoundingBox().getMinY() + this.foregroundPane.getBoundingBox().getMaxY()) / 2.0;
        double bbCenterDistanceToCenterX = this.getLayoutBounds().getWidth() / 2.0 - boundingBoxCenterX;
        double bbCenterDistanceToCenterY = this.getLayoutBounds().getHeight() / 2.0 - boundingBoxCenterY;
        double transitionX = polygonDistanceToCenterX - bbCenterDistanceToCenterX;
        double transitionY = polygonDistanceToCenterY - bbCenterDistanceToCenterY;
        return new Point2D(transitionX, transitionY);
    }

    static {
        LOGGER = LoggerFactory.getLogger(LocationPane.class);
    }
}

