/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.mainmenupanes;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.layout.VBox;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.mainmenupanes.PaneElement;

public class SettingsPane
extends PaneElement {
    private final ChoiceBox<String> themeChoice;
    private final ChoiceBox<String> languageChoice;
    private final ObservableList<String> availableThemes;
    private final ObservableList<String> availableLanguages;
    private final ObserverLabel settingsLbl;
    private final SVGIcon settingsIcon;
    private final SVGIcon statusIcon;

    public SettingsPane() {
        ResourceBundle languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());
        VBox verticalLayout = new VBox();
        this.statusIcon = new SVGIcon((GlyphIcons)MaterialIcon.TUNE, 32.0, true);
        this.getStyleClass().add((Object)"settings-pane");
        this.settingsIcon = new SVGIcon((GlyphIcons)MaterialIcon.TUNE, 16.0, true);
        this.settingsLbl = new ObserverLabel("settings", (Node)this.settingsIcon);
        this.availableLanguages = FXCollections.observableArrayList((Object[])new String[]{"English", "Deutsch"});
        this.languageChoice = new ChoiceBox(this.availableLanguages);
        this.languageChoice.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.availableThemes = FXCollections.observableArrayList((Object[])new String[]{languageBundle.getString("light"), languageBundle.getString("dark")});
        this.themeChoice = new ChoiceBox(this.availableThemes);
        this.themeChoice.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        verticalLayout.getChildren().addAll((Object[])new Node[]{this.languageChoice, this.themeChoice});
        verticalLayout.setSpacing(10.0);
        this.getChildren().addAll((Object[])new Node[]{verticalLayout});
        this.setFillWidth(true);
    }

    public ChoiceBox<String> getThemeChoice() {
        return this.themeChoice;
    }

    public ChoiceBox<String> getLanguageChoice() {
        return this.languageChoice;
    }

    public ObservableList<String> getAvailableThemes() {
        return this.availableThemes;
    }

    public ObservableList<String> getAvailableLanguages() {
        return this.availableLanguages;
    }

    public ObserverLabel getSettingsLbl() {
        return this.settingsLbl;
    }

    @Override
    public Node getStatusIcon() {
        return this.statusIcon;
    }
}

