/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.pane.unit.location;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.concurrent.Future;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.generic.ColorChooser;
import org.openbase.bco.bcozy.view.pane.unit.AbstractUnitPane;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.schedule.RecurrenceEventFilter;
import org.openbase.jul.visual.javafx.transform.JFXColorToHSBColorTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.location.LocationDataType;
import rst.vision.HSBColorType;

public class LocationPane
extends AbstractUnitPane<LocationRemote, LocationDataType.LocationData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocationPane.class);
    private ColorChooser colorChooser;
    private final RecurrenceEventFilter<Color> recurrenceEventFilterHSV = new RecurrenceEventFilter<Color>(300L){

        public void relay() {
            try {
                ((LocationRemote)LocationPane.this.getUnitRemote()).setColor(JFXColorToHSBColorTransformer.transform((Color)((Color)this.getLastValue())));
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not send color update!", (Throwable)ex, (Logger)LOGGER);
            }
        }
    };

    public LocationPane() {
        super(LocationRemote.class, true);
        this.setIcon((GlyphIcons)MaterialDesignIcon.LIGHTBULB_OUTLINE, (GlyphIcons)MaterialDesignIcon.LIGHTBULB);
    }

    @Override
    protected void initBodyContent(Pane bodyPane) throws CouldNotPerformException {
        this.colorChooser = new ColorChooser();
        this.colorChooser.initContent();
        this.colorChooser.selectedColorProperty().addListener(observable -> {
            try {
                this.recurrenceEventFilterHSV.trigger((Object)this.colorChooser.getSelectedColor());
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not trigger color change!", (Throwable)ex, (Logger)LOGGER);
            }
        });
        bodyPane.getChildren().add((Object)this.colorChooser);
    }

    @Override
    public void updateDynamicContent() {
        Color color;
        super.updateDynamicContent();
        PowerStateType.PowerState.State state = PowerStateType.PowerState.State.UNKNOWN;
        try {
            state = ((LocationDataType.LocationData)((LocationRemote)this.getUnitRemote()).getData()).getPowerState().getValue();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.DEBUG);
        }
        try {
            color = JFXColorToHSBColorTransformer.transform((HSBColorType.HSBColor)((LocationDataType.LocationData)this.getData()).getColorState().getColor().getHsbColor());
        }
        catch (CouldNotPerformException ex) {
            color = Color.TRANSPARENT;
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.DEBUG);
        }
        switch (state) {
            case OFF: {
                this.getIcon().setBackgroundIconColor(Color.TRANSPARENT);
                this.setInfoText("lightOff");
                this.setPrimaryActivationWithoutNotification(Boolean.FALSE);
                break;
            }
            case ON: {
                this.getIcon().setBackgroundIconColor(color);
                this.setInfoText("lightOn");
                this.setPrimaryActivationWithoutNotification(Boolean.TRUE);
                break;
            }
            default: {
                this.setInfoText("unknown");
            }
        }
    }

    @Override
    protected Future applyPrimaryActivationUpdate(boolean activation) throws CouldNotPerformException {
        return activation ? ((LocationRemote)this.getUnitRemote()).setPowerState(PowerStateType.PowerState.State.ON) : ((LocationRemote)this.getUnitRemote()).setPowerState(PowerStateType.PowerState.State.OFF);
    }
}

