/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy;

import javafx.application.Platform;
import org.openbase.bco.authentication.lib.jp.JPCredentialsDirectory;
import org.openbase.bco.authentication.lib.jp.JPInitializeCredentials;
import org.openbase.bco.bcozy.BCozy;
import org.openbase.bco.bcozy.jp.JPLanguage;
import org.openbase.jps.core.JPService;
import org.openbase.jps.preset.JPDebugMode;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.jp.JPRSBHost;
import org.openbase.jul.extension.rsb.com.jp.JPRSBPort;
import org.openbase.jul.extension.rsb.com.jp.JPRSBThreadPooling;
import org.openbase.jul.extension.rsb.com.jp.JPRSBTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BCozyLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(BCozyLauncher.class);

    public static void main(String ... args) {
        LOGGER.info("Start " + BCozy.APP_NAME + "...");
        JPService.setApplicationName((String)BCozy.APP_NAME);
        JPService.registerProperty(JPDebugMode.class);
        JPService.registerProperty(JPLanguage.class);
        JPService.registerProperty(JPInitializeCredentials.class);
        JPService.registerProperty(JPCredentialsDirectory.class);
        JPService.registerProperty(JPRSBThreadPooling.class);
        JPService.registerProperty(JPRSBHost.class);
        JPService.registerProperty(JPRSBPort.class);
        JPService.registerProperty(JPRSBTransport.class);
        try {
            JPService.parseAndExitOnError((String[])args);
            Thread.setDefaultUncaughtExceptionHandler(BCozyLauncher::showError);
            BCozy.launch(BCozy.class, (String[])args);
        }
        catch (IllegalStateException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            LOGGER.info(BCozy.APP_NAME + " finished unexpected.");
        }
        LOGGER.info(BCozy.APP_NAME + " finished.");
    }

    private static void showError(Thread t, Throwable ex) {
        if (Platform.isFxApplicationThread()) {
            ExceptionPrinter.printHistory((Throwable)new FatalImplementationErrorException("Uncaught exception has occured!", (Object)"FxApplicationThread", ex), (Logger)LOGGER);
        } else {
            ExceptionPrinter.printHistory((Throwable)new FatalImplementationErrorException("Uncaught exception has occured!", (Object)t.getName(), ex), (Logger)LOGGER);
        }
    }
}

