/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import com.google.protobuf.GeneratedMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javax.vecmath.Point3d;
import org.openbase.bco.bcozy.view.UnitSymbolsPane;
import org.openbase.bco.bcozy.view.location.LocationPane;
import org.openbase.bco.bcozy.view.pane.unit.TitledUnitPaneContainer;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rct.Transform;
import rst.domotic.registry.LocationRegistryDataType;
import rst.domotic.registry.UnitRegistryDataType;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.location.LocationConfigType;
import rst.geometry.AxisAlignedBoundingBox3DFloatType;
import rst.geometry.PoseType;

public class UnitsPaneController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitsPaneController.class);
    private final LocationPane locationPane;
    private final UnitSymbolsPane unitSymbolsPane;
    private final Map<String, TitledUnitPaneContainer> titledPaneMap;

    public UnitsPaneController(UnitSymbolsPane unitPane, LocationPane locationPane) {
        this.locationPane = locationPane;
        this.unitSymbolsPane = unitPane;
        this.titledPaneMap = new HashMap<String, TitledUnitPaneContainer>();
        unitPane.scaleXProperty().bind((ObservableValue)locationPane.scaleXProperty());
        unitPane.scaleYProperty().bind((ObservableValue)locationPane.scaleYProperty());
        unitPane.translateXProperty().bind((ObservableValue)locationPane.translateXProperty());
        unitPane.translateYProperty().bind((ObservableValue)locationPane.translateYProperty());
    }

    public void connectUnitRemote() throws CouldNotPerformException, InterruptedException {
        try {
            Registries.waitForData();
            Registries.getUnitRegistry().addDataObserver((Observer)new Observer<UnitRegistryDataType.UnitRegistryData>(){

                public void update(Observable<UnitRegistryDataType.UnitRegistryData> source, UnitRegistryDataType.UnitRegistryData data) throws InterruptedException {
                    Platform.runLater(() -> {
                        try {
                            UnitsPaneController.this.fetchLocationUnitRemotes();
                            UnitsPaneController.this.unitSymbolsPane.updateUnitsPane();
                        }
                        catch (CouldNotPerformException ex) {
                            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    });
                }
            });
            Registries.getLocationRegistry().addDataObserver((Observer)new Observer<LocationRegistryDataType.LocationRegistryData>(){

                public void update(Observable<LocationRegistryDataType.LocationRegistryData> source, LocationRegistryDataType.LocationRegistryData data) throws Exception {
                    Platform.runLater(() -> {
                        try {
                            UnitsPaneController.this.fetchLocationUnitRemotes();
                            UnitsPaneController.this.unitSymbolsPane.updateUnitsPane();
                        }
                        catch (CouldNotPerformException ex) {
                            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    });
                }
            });
            this.updateUnits();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not fetch units from remote registry", (Throwable)ex);
        }
    }

    public void fetchLocationUnitRemotes() throws CouldNotPerformException, InterruptedException {
        double halfButtonSize = 26.0;
        List locationUnitConfigList = Registries.getLocationRegistry().getLocationConfigs();
        for (UnitConfigType.UnitConfig locationConfig : locationUnitConfigList) {
            if (locationConfig.getLocationConfig().getType() != LocationConfigType.LocationConfig.LocationType.TILE || locationConfig.getPlacementConfig().getShape().getFloorCount() == 0) continue;
            Point3d vertex = this.calculateCoordinates(locationConfig);
            try {
                Future transform = Registries.getLocationRegistry().getUnitTransformation(locationConfig, Registries.getLocationRegistry().getRootLocationConfig());
                ((Transform)transform.get(1000L, TimeUnit.MILLISECONDS)).getTransform().transform(vertex);
                Point2D coord = new Point2D(vertex.x * 50.0, vertex.y * 50.0);
                UnitRemote u = Units.getUnit((String)locationConfig.getId(), (boolean)false);
                this.unitSymbolsPane.addRoomUnit((UnitRemote<? extends GeneratedMessage>)u, coord.add(-26.0, -26.0));
            }
            catch (ExecutionException | TimeoutException | CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            }
            for (Map.Entry nextEntry : ((LocationRemote)Units.getUnit((String)locationConfig.getId(), (boolean)false, (Class)Units.LOCATION)).getUnitMap().entrySet()) {
                if (((List)nextEntry.getValue()).isEmpty()) continue;
                for (UnitRemote u : (List)nextEntry.getValue()) {
                    UnitConfigType.UnitConfig config;
                    if (nextEntry.getKey() != UnitTemplateType.UnitTemplate.UnitType.COLORABLE_LIGHT || (config = (UnitConfigType.UnitConfig)u.getConfig()).getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED || !config.getPlacementConfig().hasPosition()) continue;
                    PoseType.Pose pose = config.getPlacementConfig().getPosition();
                    try {
                        Future transform = Registries.getLocationRegistry().getUnitTransformation(config, Registries.getLocationRegistry().getRootLocationConfig());
                        Point3d unitVertex = new Point3d(pose.getTranslation().getX(), pose.getTranslation().getY(), 1.0);
                        ((Transform)transform.get(1000L, TimeUnit.MILLISECONDS)).getTransform().transform(unitVertex);
                        Point2D coord = new Point2D(unitVertex.x * 50.0, unitVertex.y * 50.0);
                        this.unitSymbolsPane.addUnit((UnitRemote<? extends GeneratedMessage>)u, coord.add(-26.0, -26.0), locationConfig.getId());
                    }
                    catch (ExecutionException | TimeoutException | CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
                    }
                }
            }
        }
    }

    private Point3d calculateCoordinates(UnitConfigType.UnitConfig locationConfig) {
        AxisAlignedBoundingBox3DFloatType.AxisAlignedBoundingBox3DFloat boundingBox = locationConfig.getPlacementConfig().getShape().getBoundingBox();
        double d = boundingBox.getDepth();
        double w = boundingBox.getWidth();
        double new_x = (boundingBox.getLeftFrontBottom().getX() + w) / 2.0;
        double new_y = (boundingBox.getLeftFrontBottom().getY() + d) / 2.0;
        return new Point3d(new_x, new_y, 1.0);
    }

    public void updateUnits() {
        Platform.runLater(() -> {
            try {
                this.fetchLocationUnitRemotes();
                this.unitSymbolsPane.updateUnitsPane();
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        });
    }
}

