/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import org.controlsfx.control.HiddenSidesPane;
import org.openbase.bco.bcozy.view.ContextSortingPane;
import org.openbase.bco.bcozy.view.FloatingButton;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.bcozy.view.pane.unit.TitledUnitPaneContainer;

public class ContextMenu
extends VBox {
    private final ContextSortingPane contextSortingPane;
    private final Label roomInfo;
    private final ScrollPane verticalScrollPane;
    private TitledUnitPaneContainer titledPaneContainer;
    private final FloatingButton fullscreenBtn;

    public ContextMenu(double height, double width) {
        this.setMinHeight(height);
        this.setMinWidth(width);
        this.setPrefHeight(height);
        this.setPrefWidth(width);
        this.fullscreenBtn = new FloatingButton(new SVGIcon((GlyphIcons)MaterialIcon.FULLSCREEN, 48.0, true));
        this.fullscreenBtn.setAlignment(Pos.TOP_RIGHT);
        this.fullscreenBtn.translateYProperty().set(-46.0);
        this.fullscreenBtn.translateXProperty().set(85.0);
        this.fullscreenBtn.setManaged(true);
        this.roomInfo = new Label("Select a Room");
        this.roomInfo.setAlignment(Pos.TOP_CENTER);
        this.roomInfo.getStyleClass().clear();
        this.roomInfo.getStyleClass().add((Object)"headline");
        this.verticalScrollPane = new ScrollPane();
        this.verticalScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.verticalScrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        ScrollBar scrollBar = new ScrollBar();
        scrollBar.setOrientation(Orientation.VERTICAL);
        HiddenSidesPane hiddenSidesPane = new HiddenSidesPane();
        hiddenSidesPane.setContent((Node)this.verticalScrollPane);
        hiddenSidesPane.setRight((Node)scrollBar);
        hiddenSidesPane.setTriggerDistance(200.0);
        hiddenSidesPane.getStyleClass().add((Object)"hidden-sides-pane");
        scrollBar.maxProperty().bind((ObservableValue)this.verticalScrollPane.vmaxProperty());
        scrollBar.minProperty().bind((ObservableValue)this.verticalScrollPane.vminProperty());
        this.verticalScrollPane.vvalueProperty().bindBidirectional((Property)scrollBar.valueProperty());
        this.contextSortingPane = new ContextSortingPane(width + 10.0);
        this.contextSortingPane.setMaxWidth(Double.MAX_VALUE);
        this.titledPaneContainer = new TitledUnitPaneContainer();
        this.verticalScrollPane.setFitToWidth(true);
        this.verticalScrollPane.setContent((Node)this.titledPaneContainer);
        scrollBar.setVisibleAmount(0.25);
        this.getChildren().addAll((Object[])new Node[]{this.fullscreenBtn, this.roomInfo, hiddenSidesPane});
        this.getStyleClass().addAll((Object[])new String[]{"detail-menu"});
    }

    public Label getRoomInfo() {
        return this.roomInfo;
    }

    public TitledUnitPaneContainer getTitledPaneContainer() {
        return this.titledPaneContainer;
    }

    public void setTitledPaneContainer(TitledUnitPaneContainer titledPaneContainer) {
        this.titledPaneContainer = titledPaneContainer;
        this.verticalScrollPane.setContent((Node)this.titledPaneContainer);
    }

    public void clearVerticalScrollPane() {
        this.verticalScrollPane.setContent(null);
    }

    public FloatingButton getFullscreen() {
        return this.fullscreenBtn;
    }
}

