/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javafx.beans.DefaultProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultProperty(value="identifier")
public class ObserverLabel
extends Label
implements Observer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObserverLabel.class);
    @FXML
    private SimpleStringProperty identifier = new SimpleStringProperty();
    private ResourceBundle languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());

    public ObserverLabel() {
        this.identifier.addListener((observable, oldValue, newValue) -> this.update(null, null));
        LanguageSelection.getInstance().addObserver(this);
    }

    public ObserverLabel(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    public ObserverLabel(String identifier, Node graphic) {
        this(identifier);
        super.setGraphic(graphic);
    }

    @Override
    public void update(Observable observable, Object arg) {
        if (this.getIdentifier() == null || this.getIdentifier().isEmpty()) {
            return;
        }
        try {
            this.languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());
            super.setText(this.languageBundle.getString(this.getIdentifier()));
        }
        catch (MissingResourceException ex) {
            ExceptionPrinter.printHistory((String)("Could not resolve Identifier[" + this.getIdentifier() + "]"), (Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.WARN);
            super.setText(this.getIdentifier());
        }
    }

    public void setIdentifier(String identifier) {
        this.identifier.set(identifier);
    }

    public String getIdentifier() {
        return this.identifier.get();
    }

    public SimpleStringProperty identifierProperty() {
        return this.identifier;
    }
}

