/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import org.openbase.bco.bcozy.view.AnimationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVGIcon
extends StackPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(SVGIcon.class);
    private Text backgroundIcon;
    private Text backgroundFadeIcon;
    private Text foregroundIcon;
    private Text foregroundFadeIcon;
    private final double size;
    private final boolean styled;
    private FadeTransition foregroundColorFadeAnimation;
    private FadeTransition backgroundColorFadeAnimation;
    private IconState iconState;

    public SVGIcon(GlyphIcons icon, double size, boolean styled) {
        this(size, styled);
        this.foregroundIcon = this.createIcon(icon, Layer.FOREGROUND);
        this.foregroundFadeIcon = this.createFadeIcon(icon, Layer.FOREGROUND);
        this.backgroundIcon = null;
        this.backgroundFadeIcon = null;
        this.getChildren().addAll((Object[])new Node[]{this.foregroundIcon, this.foregroundFadeIcon});
    }

    public SVGIcon(GlyphIcons backgroundIcon, GlyphIcons foregroundIcon, double size) {
        this(size, true);
        this.foregroundIcon = this.createIcon(foregroundIcon, Layer.FOREGROUND);
        this.foregroundFadeIcon = this.createFadeIcon(foregroundIcon, Layer.FOREGROUND);
        this.backgroundIcon = this.createIcon(backgroundIcon, Layer.BACKGROUND);
        this.backgroundFadeIcon = this.createFadeIcon(backgroundIcon, Layer.BACKGROUND);
        this.getChildren().addAll((Object[])new Node[]{this.backgroundIcon, this.backgroundFadeIcon, this.foregroundIcon, this.foregroundFadeIcon});
    }

    public SVGIcon(double size, boolean styled) {
        this.size = size;
        this.styled = styled;
        this.disableProperty().addListener((observable, oldValue, disabled) -> {
            if (disabled.booleanValue()) {
                this.iconState.save(this);
                this.stopAnimation();
                this.setForegroundIconColor(Color.GRAY);
                this.setBackgroundIconColor(Color.GRAY);
            } else {
                this.iconState.restore(this);
            }
        });
    }

    private Text createIcon(GlyphIcons glyphIcon, Layer layer) {
        return SVGIcon.createIcon(glyphIcon, this.size, layer == Layer.FOREGROUND && this.styled);
    }

    private Text createFadeIcon(GlyphIcons glyphIcon, Layer layer) {
        return SVGIcon.createFadeIcon(glyphIcon, this.size, layer);
    }

    private static Text createIcon(GlyphIcons glyphIcon, double size, boolean styled) {
        Text icon = GlyphsDude.createIcon((GlyphIcons)glyphIcon, (String)String.valueOf(size));
        icon.setSmooth(true);
        if (styled) {
            icon.getStyleClass().clear();
            icon.getStyleClass().add((Object)"icons");
        }
        return icon;
    }

    private static Text createFadeIcon(GlyphIcons glyphIcon, double size, Layer layer) {
        Text icon = SVGIcon.createIcon(glyphIcon, size, layer == Layer.FOREGROUND);
        icon.setOpacity(0.0);
        return icon;
    }

    public void fadeForegroundFromTransparentToOpaque(int cycleCount) {
        this.stopForegroundAnimation();
        this.foregroundColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.foregroundIcon, 0.0, 1.0, cycleCount, 2000.0);
        this.foregroundColorFadeAnimation.setOnFinished(event -> this.foregroundIcon.setOpacity(1.0));
        this.foregroundColorFadeAnimation.play();
    }

    public void fadeForegroundFromOpaqueToTransparent(int cycleCount) {
        this.stopForegroundAnimation();
        this.foregroundColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.foregroundIcon, 1.0, 0.0, cycleCount, 2000.0);
        this.foregroundColorFadeAnimation.setOnFinished(event -> this.foregroundIcon.setOpacity(0.0));
        this.foregroundColorFadeAnimation.play();
    }

    public void fadeBackgroundFromTransparentToOpaque(int cycleCount) {
        this.stopBackgroundAnimation();
        this.backgroundColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.backgroundIcon, 0.0, 1.0, 1, 2000.0);
        this.backgroundColorFadeAnimation.setOnFinished(event -> this.backgroundIcon.setOpacity(1.0));
        this.backgroundColorFadeAnimation.play();
    }

    public void fadeBackgroundFromOpaqueToTransparent(int cycleCount) {
        this.stopBackgroundAnimation();
        this.backgroundColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.backgroundIcon, 1.0, 0.0, cycleCount, 2000.0);
        this.backgroundColorFadeAnimation.setOnFinished(event -> this.backgroundIcon.setOpacity(0.0));
        this.backgroundColorFadeAnimation.play();
    }

    public void startForgroundAnimation(int cycleCount) {
        this.foregroundColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.foregroundIcon, 0.0, 1.0, cycleCount, 2000.0);
        this.foregroundColorFadeAnimation.setOnFinished(event -> this.foregroundIcon.setOpacity(0.0));
        this.foregroundColorFadeAnimation.play();
    }

    public void startBackgroundAnimation(int cycleCount) {
        if (this.backgroundIcon == null) {
            LOGGER.warn("Background animation skipped because background icon not set!");
            return;
        }
        this.backgroundColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.backgroundIcon, 0.0, 1.0, cycleCount, 2000.0);
        this.backgroundColorFadeAnimation.setOnFinished(event -> this.backgroundIcon.setOpacity(0.0));
        this.backgroundColorFadeAnimation.play();
    }

    public void stopForegroundAnimation() {
        if (this.foregroundColorFadeAnimation != null) {
            this.foregroundColorFadeAnimation.stop();
        }
    }

    public void stopBackgroundAnimation() {
        if (this.backgroundColorFadeAnimation != null) {
            this.backgroundColorFadeAnimation.stop();
        }
    }

    public void stopAnimation() {
        this.stopForegroundAnimation();
        this.stopBackgroundAnimation();
    }

    public void setForegroundIconColorAnimated(Color color, int cycleCount) {
        assert (color != null);
        this.stopForegroundAnimation();
        this.foregroundFadeIcon.setFill((Paint)color);
        this.foregroundColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.foregroundFadeIcon, 0.0, 1.0, -1, 400.0);
        this.foregroundColorFadeAnimation.setOnFinished(event -> {
            this.foregroundFadeIcon.setFill((Paint)color);
            this.foregroundFadeIcon.setOpacity(0.0);
        });
        this.foregroundColorFadeAnimation.play();
    }

    public void setBackgroundIconColorAnimated(Color color, int cycleCount) {
        if (this.backgroundIcon == null) {
            LOGGER.warn("Background modification skipped because background icon not set!");
            return;
        }
        this.stopBackgroundAnimation();
        this.backgroundFadeIcon.setFill((Paint)color);
        this.backgroundColorFadeAnimation = AnimationProvider.createFadeTransition((Node)this.backgroundFadeIcon, 0.0, 1.0, cycleCount, 400.0);
        this.backgroundColorFadeAnimation.setOnFinished(event -> {
            this.backgroundFadeIcon.setFill((Paint)color);
            this.backgroundFadeIcon.setOpacity(0.0);
        });
        this.backgroundColorFadeAnimation.play();
    }

    public void setForegroundIconColor(Color color) {
        this.stopForegroundAnimation();
        this.foregroundIcon.setFill((Paint)color);
        this.foregroundIcon.setStroke((Paint)Color.TRANSPARENT);
        this.foregroundIcon.setStrokeWidth(0.0);
        this.foregroundFadeIcon.setFill((Paint)Color.TRANSPARENT);
    }

    public void setBackgroundIconColor(Color color) {
        if (this.backgroundIcon == null) {
            LOGGER.warn("Background modification skipped because background icon not set!");
            return;
        }
        this.stopBackgroundAnimation();
        this.backgroundIcon.setFill((Paint)color);
        this.backgroundFadeIcon.setFill((Paint)Color.TRANSPARENT);
    }

    public void setForegroundIconColor(Color color, Color outline, double width) {
        this.setForegroundIconColor(color);
        this.foregroundIcon.setStroke((Paint)outline);
        this.foregroundIcon.setStrokeWidth(width);
    }

    public void seBackgroundIconColor(Color color, Color outline, double width) {
        this.setBackgroundIconColor(color);
        this.backgroundIcon.setStroke((Paint)outline);
        this.backgroundIcon.setStrokeWidth(width);
    }

    public void setForegroundIconColorDefault() {
        this.stopForegroundAnimation();
        this.foregroundIcon.getStyleClass().clear();
        this.foregroundIcon.getStyleClass().add((Object)"icons");
        this.foregroundFadeIcon.setFill((Paint)Color.TRANSPARENT);
    }

    public void setBackgroundIconColorDefault() {
        if (this.backgroundIcon == null) {
            LOGGER.warn("Background modification skipped because background icon not set!");
            return;
        }
        this.stopBackgroundAnimation();
        this.backgroundIcon.getStyleClass().clear();
        this.backgroundIcon.getStyleClass().add((Object)"icons");
        this.backgroundFadeIcon.setFill((Paint)Color.TRANSPARENT);
    }

    public void setForegroundIconColorDefaultInverted() {
        this.setForegroundIconColorDefault();
        this.setForegroundIconColor(this.getForegroundIconColor().invert());
    }

    public void setBackgroundIconColorDefaultInverted() {
        if (this.backgroundIcon == null) {
            LOGGER.warn("Background modification skipped because background icon not set!");
            return;
        }
        this.setBackgroundIconColorDefault();
        this.setBackgroundIconColor(this.getBackgroundIconColor().invert());
    }

    public void setForegroundIcon(GlyphIcons icon) {
        this.setForegroundIcon(icon, null);
    }

    public void setBackgroundIcon(GlyphIcons icon) {
        this.setBackgroundIcon(icon, null);
    }

    public void setForegroundIcon(GlyphIcons icon, Color color) {
        Text oldForegroundIcon = this.foregroundIcon;
        Text oldForegroundFadeIcon = this.foregroundFadeIcon;
        this.foregroundIcon = this.createIcon(icon, Layer.FOREGROUND);
        this.foregroundFadeIcon = this.createFadeIcon(icon, Layer.FOREGROUND);
        if (color != null) {
            this.setForegroundIconColor(color);
        }
        this.getChildren().replaceAll(node -> {
            if (node.equals(oldForegroundIcon)) {
                return this.foregroundIcon;
            }
            if (node.equals(oldForegroundFadeIcon)) {
                return this.foregroundFadeIcon;
            }
            return node;
        });
    }

    public void setBackgroundIcon(GlyphIcons icon, Color color) {
        Text oldBackgroundIcon = this.backgroundIcon;
        Text oldBackgroundFadeIcon = this.backgroundFadeIcon;
        this.backgroundIcon = this.createIcon(icon, Layer.BACKGROUND);
        this.backgroundFadeIcon = this.createFadeIcon(icon, Layer.BACKGROUND);
        if (color != null) {
            this.setBackgroundIconColor(color);
        }
        if (oldBackgroundIcon == null || oldBackgroundFadeIcon == null) {
            this.getChildren().clear();
            this.getChildren().addAll((Object[])new Node[]{this.backgroundIcon, this.backgroundFadeIcon, this.foregroundIcon, this.foregroundFadeIcon});
            return;
        }
        this.getChildren().replaceAll(node -> {
            if (node.equals(oldBackgroundIcon)) {
                return this.backgroundIcon;
            }
            if (node.equals(oldBackgroundFadeIcon)) {
                return this.backgroundFadeIcon;
            }
            return node;
        });
    }

    public Color getForegroundIconColor() {
        return (Color)this.foregroundIcon.getFill();
    }

    public Color getBackgroundIconColor() {
        if (this.backgroundIcon == null) {
            LOGGER.warn("Background color unknown because background icon not set!");
            return Color.TRANSPARENT;
        }
        return (Color)this.backgroundIcon.getFill();
    }

    public double getSize() {
        return this.size;
    }

    private class IconState {
        private Boolean foregroundAnimated;
        private Boolean backgroundAnimated;
        private Color foregroundColor;
        private Color backgroundColor;

        private IconState() {
        }

        public boolean forgroundAnimated() {
            return this.foregroundAnimated;
        }

        public boolean backgroundAnimated() {
            return this.backgroundAnimated;
        }

        public void setForegroundAnimated(boolean animated) {
            this.foregroundAnimated = animated;
        }

        public void setBackgroundAnimated(boolean animated) {
            this.backgroundAnimated = animated;
        }

        public Color getForegroundColor() {
            return this.foregroundColor;
        }

        public void setForegroundColor(Color foregroundColor) {
            this.foregroundColor = foregroundColor;
        }

        public Color getBackgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public void save(SVGIcon icon) {
            assert (icon != null);
            this.foregroundAnimated = icon.foregroundColorFadeAnimation != null && icon.foregroundColorFadeAnimation.getStatus().equals((Object)Animation.Status.RUNNING);
            this.backgroundAnimated = icon.backgroundColorFadeAnimation != null && icon.backgroundColorFadeAnimation.getStatus().equals((Object)Animation.Status.RUNNING);
            this.foregroundColor = icon.getForegroundIconColor();
            this.backgroundColor = icon.getBackgroundIconColor();
        }

        public void restore(SVGIcon icon) {
            if (icon == null) {
                return;
            }
            if (this.foregroundAnimated != null) {
                this.setForegroundAnimated(this.foregroundAnimated);
            }
            if (this.backgroundAnimated != null) {
                this.setBackgroundAnimated(this.backgroundAnimated);
            }
            if (this.foregroundColor != null) {
                icon.setForegroundIconColor(this.foregroundColor);
            }
            if (this.backgroundColor != null) {
                icon.setBackgroundIconColor(this.backgroundColor);
            }
        }
    }

    public static enum Layer {
        FOREGROUND,
        BACKGROUND;

    }
}

