/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.generic;

import com.jfoenix.controls.JFXToggleButton;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.util.concurrent.Future;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.openbase.bco.bcozy.view.ObserverText;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.visual.javafx.iface.DynamicPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetPane
extends VBox
implements DynamicPane {
    protected final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ObserverText infoText = new ObserverText("DUMMY");
    private final JFXToggleButton toggleSwitch = new JFXToggleButton();
    private final GridPane iconPane = new GridPane();
    private final Tooltip tooltip = new Tooltip("");
    private final SVGIcon mainIcon;
    private final Label widgetLabel;
    final BorderPane headPane;
    protected final BooleanProperty primaryActivationProperty;
    protected final BooleanProperty secondaryActivationProperty;
    private final ChangeListener<Boolean> primaryActivationObserver;
    private final boolean activateable;

    public void setDisplayMode(DisplayMode displayMode) {
        switch (displayMode) {
            case ICON_ONLY: {
                this.headPane.setCenter(null);
                this.headPane.setRight(null);
                this.headPane.getStyleClass().clear();
                this.headPane.getStyleClass().add((Object)"head-pane-2");
                break;
            }
        }
    }

    public WidgetPane(boolean activateable) {
        this.activateable = activateable;
        this.headPane = new BorderPane();
        this.primaryActivationProperty = new SimpleBooleanProperty();
        this.secondaryActivationProperty = new SimpleBooleanProperty();
        this.mainIcon = new SVGIcon((GlyphIcons)MaterialDesignIcon.VECTOR_CIRCLE, 32.0, false);
        this.widgetLabel = new Label("?");
        this.primaryActivationObserver = new ChangeListener<Boolean>(){
            private Future currentTask;

            public void changed(ObservableValue<? extends Boolean> observable, Boolean lastActivation, Boolean newActivation) {
                try {
                    if (this.currentTask != null) {
                        this.currentTask.cancel(true);
                    }
                    this.currentTask = WidgetPane.this.applyPrimaryActivationUpdate(newActivation);
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((String)("Could not apply activation update " + this), (Throwable)ex, (Logger)WidgetPane.this.LOGGER);
                }
            }
        };
        this.primaryActivationProperty().addListener(this.primaryActivationObserver);
    }

    public void initContent() {
        this.toggleSwitch.getStyleClass().clear();
        this.toggleSwitch.setMouseTransparent(true);
        Tooltip.install((Node)this.iconPane, (Tooltip)this.tooltip);
        this.initHeadPane();
        if (this.headPane.getCenter() != null) {
            BorderPane.setMargin((Node)this.headPane.getCenter(), (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        }
        if (this.headPane.getRight() != null) {
            BorderPane.setMargin((Node)this.headPane.getRight(), (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        }
        this.getChildren().add((Object)this.headPane);
        if (this.activateable) {
            EventHandler<MouseEvent> mouseEventHandler = new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    if (!event.isStillSincePress()) {
                        return;
                    }
                    try {
                        switch (event.getButton()) {
                            case PRIMARY: {
                                WidgetPane.this.togglePrimaryActivation();
                                break;
                            }
                            case SECONDARY: {
                                WidgetPane.this.toggleSecondaryActivation();
                            }
                        }
                    }
                    catch (RuntimeException ex) {
                        ExceptionPrinter.printHistory((String)"Could not handle mouse event!", (Throwable)ex, (Logger)WidgetPane.this.LOGGER);
                    }
                    event.consume();
                }
            };
            this.toggleSwitch.selectedProperty().bindBidirectional((Property)this.primaryActivationProperty);
            this.toggleSwitch.setOnMouseClicked((EventHandler)mouseEventHandler);
            this.headPane.setOnMouseClicked((EventHandler)mouseEventHandler);
            this.headPane.setOnSwipeDown(event -> this.secondaryActivationProperty.set(true));
            this.headPane.setOnSwipeUp(event -> this.secondaryActivationProperty.set(false));
            this.headPane.setOnScrollStarted(event -> {
                if (event.getDeltaY() > 0.0) {
                    this.secondaryActivationProperty.set(true);
                } else if (event.getDeltaY() < 0.0) {
                    this.secondaryActivationProperty.set(false);
                }
            });
        }
    }

    public void initHeadPane() {
        this.headPane.getStyleClass().clear();
        this.headPane.getStyleClass().add((Object)"head-pane");
        this.iconPane.getStyleClass().add((Object)"icons");
        this.iconPane.add((Node)this.mainIcon, 0, 0);
        this.iconPane.setAlignment(Pos.CENTER);
        this.toggleSwitch.setBackground(Background.EMPTY);
        this.headPane.setLeft((Node)this.iconPane);
        BorderPane.setAlignment((Node)this.iconPane, (Pos)Pos.CENTER);
        this.headPane.setCenter((Node)this.widgetLabel);
        BorderPane.setAlignment((Node)this.widgetLabel, (Pos)Pos.CENTER_LEFT);
        if (this.activateable) {
            this.headPane.setRight((Node)this.toggleSwitch);
            BorderPane.setAlignment((Node)this.toggleSwitch, (Pos)Pos.CENTER);
        }
    }

    public void setIcon(GlyphIcons foregroundIcon, Color foregroundIconColor, GlyphIcons backgroundIcon, Color backgroundIconColor) {
        this.mainIcon.setForegroundIcon(foregroundIcon, foregroundIconColor);
        this.mainIcon.setBackgroundIcon(backgroundIcon, backgroundIconColor);
    }

    public void setIcon(GlyphIcons foregroundIcon, GlyphIcons backgroundIcon) {
        this.mainIcon.setForegroundIcon(foregroundIcon);
        this.mainIcon.setBackgroundIcon(backgroundIcon);
    }

    public void setLabel(String label) {
        this.widgetLabel.setText(label);
    }

    public SVGIcon getIcon() {
        return this.mainIcon;
    }

    public void updateDynamicContent() {
    }

    public BooleanProperty primaryActivationProperty() {
        return this.primaryActivationProperty;
    }

    public BooleanProperty secondaryActivationProperty() {
        return this.secondaryActivationProperty;
    }

    public synchronized void setPrimaryActivationWithoutNotification(Boolean activation) {
        this.primaryActivationProperty.removeListener(this.primaryActivationObserver);
        this.primaryActivationProperty.setValue(activation);
        this.primaryActivationProperty.addListener(this.primaryActivationObserver);
    }

    public void togglePrimaryActivation() {
        this.primaryActivationProperty.set(this.primaryActivationProperty.getValue() == false);
    }

    public void toggleSecondaryActivation() {
        this.secondaryActivationProperty.set(this.secondaryActivationProperty.getValue() == false);
    }

    public void setInfoText(String identifier) {
        this.infoText.setIdentifier(identifier);
    }

    protected Future applyPrimaryActivationUpdate(boolean activation) throws CouldNotPerformException {
        return null;
    }

    public static enum DisplayMode {
        ICON_ONLY;

    }
}

