/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view.location;

import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.openbase.bco.bcozy.view.Constants;
import org.openbase.bco.bcozy.view.location.LocationPolygon;
import org.openbase.jul.exception.InstantiationException;
import rst.domotic.unit.location.LocationDataType;

public class RegionPolygon
extends LocationPolygon {
    private boolean selectable = false;

    public RegionPolygon(double ... points) throws InstantiationException {
        super(points);
    }

    @Override
    public void applyDataUpdate(LocationDataType.LocationData unitData) {
    }

    @Override
    protected void setLocationStyle() {
        this.setMainColor(Constants.REGION_FILL);
        this.setStroke((Paint)Color.WHITE);
        this.setStrokeWidth(0.0);
        this.setMouseTransparent(true);
    }

    @Override
    protected void changeStyleOnSelection(boolean selected) {
        if (selected) {
            this.setMainColor(Constants.TILE_SELECTION);
        } else {
            this.setMainColor(Constants.REGION_FILL);
        }
    }

    public void changeStyleOnSelectable(boolean selectable) {
        if (selectable) {
            this.selectable = true;
            this.getStrokeDashArray().addAll((Object[])new Double[]{4.0, 4.0});
            this.setStrokeWidth(0.5);
            this.setMouseTransparent(false);
        } else {
            this.selectable = false;
            this.getStrokeDashArray().clear();
            this.setStrokeWidth(0.0);
            this.setMouseTransparent(true);
        }
    }

    @Override
    protected void onColorChange(Color mainColor, Color customColor) {
        if (customColor.equals((Object)Color.TRANSPARENT)) {
            this.setFill((Paint)mainColor);
        } else {
            this.setFill((Paint)mainColor.interpolate(customColor, 0.5));
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void mouseEntered() {
        this.setStrokeWidth(2.0);
    }

    public void mouseLeft() {
        this.setStrokeWidth(0.5);
    }
}

