/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import com.google.protobuf.GeneratedMessage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javax.vecmath.Point3d;
import org.openbase.bco.bcozy.view.SimpleUnitSymbolsPane;
import org.openbase.bco.bcozy.view.location.LocationPane;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rct.Transform;
import rst.domotic.registry.LocationRegistryDataType;
import rst.domotic.registry.UnitRegistryDataType;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;
import rst.geometry.PoseType;

public class EditingLayerController {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditingLayerController.class);
    private final LocationPane locationPane;
    private final SimpleUnitSymbolsPane unitSymbolsPane;

    public EditingLayerController(SimpleUnitSymbolsPane unitPane, LocationPane locationPane) {
        this.locationPane = locationPane;
        this.unitSymbolsPane = unitPane;
        unitPane.scaleXProperty().bind((ObservableValue)locationPane.scaleXProperty());
        unitPane.scaleYProperty().bind((ObservableValue)locationPane.scaleYProperty());
        unitPane.translateXProperty().bind((ObservableValue)locationPane.translateXProperty());
        unitPane.translateYProperty().bind((ObservableValue)locationPane.translateYProperty());
    }

    public void connectUnitRemote() throws CouldNotPerformException, InterruptedException {
        try {
            Registries.waitForData();
            Registries.getUnitRegistry().addDataObserver((Observer)new Observer<UnitRegistryDataType.UnitRegistryData>(){

                public void update(Observable<UnitRegistryDataType.UnitRegistryData> source, UnitRegistryDataType.UnitRegistryData data) throws InterruptedException {
                    Platform.runLater(() -> {
                        try {
                            EditingLayerController.this.fetchLocationUnitRemotes();
                            EditingLayerController.this.unitSymbolsPane.updateUnitsPane();
                        }
                        catch (CouldNotPerformException ex) {
                            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    });
                }
            });
            Registries.getLocationRegistry().addDataObserver((Observer)new Observer<LocationRegistryDataType.LocationRegistryData>(){

                public void update(Observable<LocationRegistryDataType.LocationRegistryData> source, LocationRegistryDataType.LocationRegistryData data) throws Exception {
                    Platform.runLater(() -> {
                        try {
                            EditingLayerController.this.fetchLocationUnitRemotes();
                            EditingLayerController.this.unitSymbolsPane.updateUnitsPane();
                        }
                        catch (CouldNotPerformException ex) {
                            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    });
                }
            });
            this.updateUnits();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not fetch units from remote registry", (Throwable)ex);
        }
    }

    public void fetchLocationUnitRemotes() throws CouldNotPerformException, InterruptedException {
        this.unitSymbolsPane.clearUnits();
        double halfButtonSize = 26.0;
        List locationUnitConfigList = Registries.getLocationRegistry().getLocationConfigs();
        for (UnitConfigType.UnitConfig locationConfig : locationUnitConfigList) {
            if (locationConfig.getPlacementConfig().getShape().getFloorCount() == 0) continue;
            for (Map.Entry nextEntry : ((LocationRemote)Units.getUnit((String)locationConfig.getId(), (boolean)false, (Class)Units.LOCATION)).getUnitMap().entrySet()) {
                if (((List)nextEntry.getValue()).isEmpty()) continue;
                for (UnitRemote u : (List)nextEntry.getValue()) {
                    UnitConfigType.UnitConfig config = (UnitConfigType.UnitConfig)u.getConfig();
                    if (config.getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED || !config.getPlacementConfig().hasPosition()) continue;
                    PoseType.Pose pose = config.getPlacementConfig().getPosition();
                    try {
                        Future transform = Registries.getLocationRegistry().getUnitTransformation(config, Registries.getLocationRegistry().getRootLocationConfig());
                        Point3d unitVertex = new Point3d(0.0, 0.0, 1.0);
                        ((Transform)transform.get(1000L, TimeUnit.MILLISECONDS)).getTransform().transform(unitVertex);
                        Point2D coord = new Point2D(unitVertex.x * 50.0, unitVertex.y * 50.0);
                        this.unitSymbolsPane.addUnit((UnitRemote<? extends GeneratedMessage>)u, coord.add(-13.0, -26.0), config.getId());
                    }
                    catch (ExecutionException | TimeoutException | CouldNotPerformException throwable) {}
                }
            }
        }
    }

    public void updateUnits() {
        Platform.runLater(() -> {
            try {
                this.fetchLocationUnitRemotes();
                this.unitSymbolsPane.updateUnitsPane();
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        });
    }
}

