/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy;

import com.guigarage.responsive.ResponsiveHandler;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javafx.application.Application;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.openbase.bco.bcozy.controller.CenterPaneController;
import org.openbase.bco.bcozy.controller.ContextMenuController;
import org.openbase.bco.bcozy.controller.EditingLayerController;
import org.openbase.bco.bcozy.controller.LocationPaneController;
import org.openbase.bco.bcozy.controller.MainMenuController;
import org.openbase.bco.bcozy.controller.MaintenanceLayerController;
import org.openbase.bco.bcozy.controller.UnitsPaneController;
import org.openbase.bco.bcozy.view.BackgroundPane;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.ImageViewProvider;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.bco.bcozy.view.LoadingPane;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.pattern.Remote;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BCozy
extends Application {
    public static final String APP_NAME = BCozy.class.getSimpleName().toLowerCase();
    private static final Logger LOGGER = LoggerFactory.getLogger(BCozy.class);
    public static Stage primaryStage;
    private LoadingPane loadingPane;
    private ContextMenuController contextMenuController;
    private LocationPaneController locationPaneController;
    private ForegroundPane foregroundPane;
    private UnitsPaneController unitsPaneController;
    private MaintenanceLayerController maintenanceLayerController;
    private EditingLayerController editingLayerController;
    private Future initTask;
    private Scene mainScene;
    public static boolean baseColorIsWhite;
    private static Observer<Remote.ConnectionState> connectionObserver;

    public BCozy() {
        connectionObserver = new Observer<Remote.ConnectionState>(){

            public void update(Observable<Remote.ConnectionState> source, Remote.ConnectionState data) throws Exception {
                switch (data) {
                    case CONNECTED: {
                        InfoPane.confirmation("connected");
                        break;
                    }
                    case CONNECTING: {
                        InfoPane.warn("connecting");
                        break;
                    }
                    case DISCONNECTED: {
                        InfoPane.error("disconnected");
                        break;
                    }
                }
            }
        };
    }

    public void start(Stage primaryStage) throws InitializationException, InterruptedException, InstantiationException {
        BCozy.primaryStage = primaryStage;
        BCozy.registerResponsiveHandler();
        double screenWidth = Screen.getPrimary().getVisualBounds().getWidth();
        double screenHeight = Screen.getPrimary().getVisualBounds().getHeight();
        primaryStage.setTitle("BCozy");
        StackPane root = new StackPane();
        this.foregroundPane = new ForegroundPane(screenHeight, screenWidth);
        this.foregroundPane.setMinHeight(root.getHeight());
        this.foregroundPane.setMinWidth(root.getWidth());
        BackgroundPane backgroundPane = new BackgroundPane(this.foregroundPane);
        this.loadingPane = new LoadingPane(screenHeight, screenWidth);
        this.loadingPane.setMinHeight(root.getHeight());
        this.loadingPane.setMinWidth(root.getWidth());
        root.getChildren().addAll((Object[])new Node[]{backgroundPane, this.foregroundPane, this.loadingPane});
        primaryStage.setMinWidth(this.foregroundPane.getMainMenu().getMinWidth() + this.foregroundPane.getContextMenu().getMinWidth() + 300.0);
        primaryStage.setHeight(screenHeight);
        this.mainScene = new Scene((Parent)root, screenWidth, screenHeight);
        primaryStage.setScene(this.mainScene);
        primaryStage.getScene().getStylesheets().addAll((Object[])new String[]{"/css/skin.css", "/css/light.css"});
        new MainMenuController(this.foregroundPane);
        new CenterPaneController(this.foregroundPane);
        this.contextMenuController = new ContextMenuController(this.foregroundPane, backgroundPane.getLocationPane());
        this.locationPaneController = new LocationPaneController(backgroundPane.getLocationPane());
        this.unitsPaneController = new UnitsPaneController(backgroundPane.getUnitsPane(), backgroundPane.getLocationPane());
        this.maintenanceLayerController = new MaintenanceLayerController(backgroundPane.getMaintenancePane(), backgroundPane.getLocationPane());
        this.editingLayerController = new EditingLayerController(backgroundPane.getEditingPane(), backgroundPane.getLocationPane());
        ResponsiveHandler.addResponsiveToWindow((Window)primaryStage);
        primaryStage.show();
        InfoPane.confirmation("Welcome");
        try {
            Registries.getUnitRegistry().addConnectionStateObserver(connectionObserver);
        }
        catch (NotAvailableException ex) {
            ExceptionPrinter.printHistory((String)"Could not register bco connection observer!", (Throwable)ex, (Logger)LOGGER);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.initRemotesAndLocation();
    }

    private void initRemotesAndLocation() {
        this.initTask = GlobalCachedExecutorService.submit((Runnable)new Task(){

            protected Object call() throws Exception {
                try {
                    BCozy.this.loadingPane.setTextLabelIdentifier("waitForConnection");
                    Registries.waitForData();
                    BCozy.this.loadingPane.setTextLabelIdentifier("fillContextMenu");
                    BCozy.this.foregroundPane.init();
                    BCozy.this.contextMenuController.initTitledPaneMap();
                    BCozy.this.loadingPane.setTextLabelIdentifier("connectLocationRemote");
                    BCozy.this.locationPaneController.connectLocationRemote();
                    BCozy.this.unitsPaneController.connectUnitRemote();
                    BCozy.this.maintenanceLayerController.connectUnitRemote();
                    BCozy.this.editingLayerController.connectUnitRemote();
                    return null;
                }
                catch (Exception ex) {
                    BCozy.this.loadingPane.setTextLabelIdentifier("errorDuringStartup");
                    Thread.sleep(3000L);
                    FatalImplementationErrorException exx = new FatalImplementationErrorException("Could not init panes", (Object)this, (Throwable)ex);
                    ExceptionPrinter.printHistoryAndExit((Throwable)exx, (Logger)LOGGER);
                    throw exx;
                }
            }

            protected void succeeded() {
                super.succeeded();
                BCozy.this.loadingPane.setVisible(false);
            }
        });
    }

    public void stop() {
        boolean errorOccured = false;
        if (this.initTask != null && !this.initTask.isDone()) {
            this.initTask.cancel(true);
            try {
                this.initTask.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                ExceptionPrinter.printHistory((String)"Initialization phase canceled because of application shutdown.", (Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.INFO);
                errorOccured = true;
            }
            catch (CancellationException ex) {
                ExceptionPrinter.printHistory((String)"Initialization phase failed but application shutdown was initialized anyway.", (Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.WARN);
            }
        }
        try {
            Registries.getUnitRegistry().removeConnectionStateObserver(connectionObserver);
        }
        catch (NotAvailableException ex) {
            ExceptionPrinter.printHistory((String)"Could not remove bco connection observer!", (Throwable)ex, (Logger)LOGGER);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        try {
            super.stop();
        }
        catch (Exception ex) {
            ExceptionPrinter.printHistory((String)("Could not stop " + JPService.getApplicationName() + "!"), (Throwable)ex, (Logger)LOGGER);
            errorOccured = true;
        }
        if (errorOccured) {
            System.exit(255);
        }
        System.exit(0);
    }

    public static void changeTheme(String themeName) {
        if (primaryStage != null) {
            switch (themeName) {
                case "/css/dark.css": {
                    primaryStage.getScene().getStylesheets().clear();
                    primaryStage.getScene().getStylesheets().addAll((Object[])new String[]{"/css/skin.css", "/css/dark.css"});
                    ImageViewProvider.colorizeIconsToWhite();
                    baseColorIsWhite = true;
                    break;
                }
                case "/css/light.css": {
                    primaryStage.getScene().getStylesheets().clear();
                    primaryStage.getScene().getStylesheets().addAll((Object[])new String[]{"/css/skin.css", "/css/light.css"});
                    ImageViewProvider.colorizeIconsToBlack();
                    baseColorIsWhite = false;
                    break;
                }
                default: {
                    primaryStage.getScene().getStylesheets().clear();
                }
            }
        }
    }

    private static void registerResponsiveHandler() {
        LOGGER.info("Executing Registration of Listeners");
        ResponsiveHandler.setOnDeviceTypeChanged((over, oldDeviceType, newDeviceType) -> {
            switch (newDeviceType) {
                case LARGE: {
                    BCozy.adjustToLargeDevice();
                    break;
                }
                case MEDIUM: {
                    BCozy.adjustToMediumDevice();
                    break;
                }
                case SMALL: {
                    BCozy.adjustToSmallDevice();
                    break;
                }
                case EXTRA_SMALL: {
                    BCozy.adjustToExtremeSmallDevice();
                    break;
                }
            }
        });
    }

    private static void adjustToLargeDevice() {
        LOGGER.info("Detected Large Device");
    }

    private static void adjustToMediumDevice() {
        LOGGER.info("Detected Medium Device");
    }

    private static void adjustToSmallDevice() {
        LOGGER.info("Detected Small Device");
    }

    private static void adjustToExtremeSmallDevice() {
        LOGGER.info("Detected Extreme Small Device");
    }

    static {
        baseColorIsWhite = true;
    }
}

