/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.util.Callback;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.openbase.bco.bcozy.util.AuthorizationGroups;
import org.openbase.bco.bcozy.view.ObserverButton;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class AuthorizationGroupController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationGroupController.class);
    @FXML
    private ObserverButton saveButton;
    @FXML
    private TextField label;
    @FXML
    private TableColumn<UnitConfigType.UnitConfig, String> removeColumn;
    @FXML
    private TableColumn<UnitConfigType.UnitConfig, String> nameColumn;
    @FXML
    private TableView<UnitConfigType.UnitConfig> groupsTable;
    @FXML
    private Pane root;
    private ObservableList<UnitConfigType.UnitConfig> groups = AuthorizationGroups.getAuthorizationGroups();

    @FXML
    public void initialize() {
        this.saveButton.setApplyOnNewText(String::toUpperCase);
        this.nameColumn.setCellValueFactory(param -> new SimpleStringProperty(((UnitConfigType.UnitConfig)param.getValue()).getLabel()));
        LanguageSelection.addObserverFor("groupLabel", (locale, text) -> this.nameColumn.setText(text));
        this.removeColumn.setCellFactory(this.cellFactory());
        this.groupsTable.widthProperty().addListener((observable, oldValue, newValue) -> this.nameColumn.setPrefWidth(newValue.doubleValue() - this.removeColumn.getWidth() - 2.0));
        this.groupsTable.setEditable(false);
        this.nameColumn.setResizable(false);
        this.removeColumn.setResizable(false);
        this.groupsTable.setItems(this.groups);
        LanguageSelection.addObserverFor("groupLabel", (locale, text) -> this.label.setPromptText(text));
    }

    public Pane getRoot() {
        return this.root;
    }

    private Callback<TableColumn<UnitConfigType.UnitConfig, String>, TableCell<UnitConfigType.UnitConfig, String>> cellFactory() {
        return new Callback<TableColumn<UnitConfigType.UnitConfig, String>, TableCell<UnitConfigType.UnitConfig, String>>(){

            public TableCell<UnitConfigType.UnitConfig, String> call(TableColumn<UnitConfigType.UnitConfig, String> param) {
                TableCell<UnitConfigType.UnitConfig, String> cell = new TableCell<UnitConfigType.UnitConfig, String>(){
                    final Button btn = new Button();
                    {
                        this.btn.setGraphic((Node)new SVGIcon((GlyphIcons)FontAwesomeIcon.TIMES, 16.0, true));
                    }

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setOnAction(event -> {
                                try {
                                    AuthorizationGroups.removeAuthorizationGroup((UnitConfigType.UnitConfig)this.getTableView().getItems().get(this.getIndex()));
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                }
                                catch (CouldNotPerformException ex) {
                                    ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
                                }
                            });
                            this.setGraphic((Node)this.btn);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
    }

    @FXML
    private void addGroup(ActionEvent actionEvent) {
        try {
            AuthorizationGroups.addAuthorizationGroup(this.label.getText());
            this.label.clear();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (CouldNotPerformException ex) {
            this.label.getStyleClass().add((Object)"text-field-wrong");
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
    }
}

