/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import javafx.application.Platform;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.mainmenupanes.AvailableUsersPane;
import org.openbase.bco.bcozy.view.mainmenupanes.ConnectionPane;
import org.openbase.bco.bcozy.view.mainmenupanes.LoginPane;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class MainMenuController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainMenuController.class);
    private LoginPane loginPane;
    private AvailableUsersPane availableUsersPane;
    private ConnectionPane connectionPane;

    public MainMenuController() {
    }

    public MainMenuController(ForegroundPane foregroundPane) {
        this.init(foregroundPane);
    }

    public void init(ForegroundPane foregroundPane) {
        this.loginPane = foregroundPane.getMainMenu().getLoginPane();
        this.availableUsersPane = foregroundPane.getMainMenu().getAvailableUsersPanePane();
        this.connectionPane = foregroundPane.getMainMenu().getConnectionPane();
        this.loginPane.getLoginBtn().setOnAction(event -> this.loginUser());
        this.loginPane.getLogoutBtn().setOnAction(event -> this.resetLogin());
        this.loginPane.getPasswordField().setOnAction(event -> this.loginUser());
        this.loginPane.getNameTxt().setOnAction(event -> this.loginUser());
        this.loginPane.getNameTxt().setOnKeyTyped(event -> this.resetWrongInput());
        this.loginPane.getPasswordField().setOnKeyTyped(event -> this.resetWrongInput());
        this.loginPane.getStatusIcon().setOnMouseClicked(event -> this.showHideMainMenu(foregroundPane));
        this.availableUsersPane.getStatusIcon().setOnMouseClicked(event -> this.showHideMainMenu(foregroundPane));
        this.connectionPane.getStatusIcon().setOnMouseClicked(event -> this.showHideMainMenu(foregroundPane));
        foregroundPane.getMainMenu().getMainMenuFloatingButton().setOnAction(event -> this.showHideMainMenu(foregroundPane));
    }

    private void startLogin() {
        this.loginPane.setState(LoginPane.State.LOGINACTIVE);
    }

    private void resetWrongInput() {
        if (this.loginPane.getInputWrongLbl().isVisible()) {
            this.loginPane.resetUserOrPasswordWrong();
        }
    }

    private void loginUser() {
        GlobalCachedExecutorService.submit(() -> {
            try {
                this.loginUserAsync();
            }
            catch (InterruptedException ex) {
                ExceptionPrinter.printHistory((String)"Could not login!", (Throwable)ex, (Logger)LOGGER);
            }
        });
    }

    private void loginUserAsync() throws InterruptedException {
        SessionManager sessionManager = SessionManager.getInstance();
        try {
            String username = this.loginPane.getNameTxt().getText();
            String userUnitId = null;
            for (UnitConfigType.UnitConfig userUnitConfig : Registries.getUserRegistry().getUserConfigs()) {
                if (!userUnitConfig.getUserConfig().getUserName().equals(username)) continue;
                userUnitId = userUnitConfig.getId();
            }
            if (userUnitId == null) {
                throw new InvalidStateException("username does not exists!");
            }
            sessionManager.login(userUnitId, this.loginPane.getPasswordField().getText());
            Platform.runLater(() -> {
                this.loginPane.resetUserOrPasswordWrong();
                this.loginPane.getLoggedInUserLbl().setText(this.loginPane.getNameTxt().getText());
                this.loginPane.getNameTxt().setText("");
                this.loginPane.getPasswordField().setText("");
                this.loginPane.setState(LoginPane.State.LOGOUT);
            });
        }
        catch (CouldNotPerformException ex) {
            Platform.runLater(() -> this.loginPane.indicateUserOrPasswordWrong());
        }
        catch (OutOfMemoryError error) {
            LOGGER.error(error.getMessage());
        }
    }

    private void resetLogin() {
        SessionManager.getInstance().logout();
        if (this.loginPane.getInputWrongLbl().isVisible()) {
            this.loginPane.resetUserOrPasswordWrong();
        }
        this.loginPane.getNameTxt().setText("");
        this.loginPane.getPasswordField().setText("");
        this.loginPane.getLoggedInUserLbl().setText("");
        this.loginPane.setState(LoginPane.State.LOGINACTIVE);
    }

    private void showHideMainMenu(ForegroundPane foregroundPane) {
        if (foregroundPane.getMainMenu().isMaximized()) {
            foregroundPane.getMainMenu().minimizeMainMenu();
        } else {
            foregroundPane.getMainMenu().maximizeMainMenu();
        }
    }
}

