/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import com.jfoenix.controls.JFXCheckBox;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import org.controlsfx.control.CheckComboBox;
import org.openbase.bco.bcozy.model.SessionManagerFacade;
import org.openbase.bco.bcozy.model.SessionManagerFacadeImpl;
import org.openbase.bco.bcozy.util.AuthorizationGroups;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.bco.bcozy.view.ObserverButton;
import org.openbase.bco.bcozy.view.ObserverLabel;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.user.UserConfigType;

public class RegistrationController {
    private static final Logger logger = LoggerFactory.getLogger(RegistrationController.class);
    private SessionManagerFacade sessionManager = new SessionManagerFacadeImpl();
    @FXML
    private Pane root;
    @FXML
    private PasswordField passwordField;
    @FXML
    private PasswordField repeatPasswordField;
    @FXML
    private TextField username;
    @FXML
    private TextField firstname;
    @FXML
    private TextField lastname;
    @FXML
    private TextField mail;
    @FXML
    private TextField phone;
    @FXML
    private CheckComboBox<UnitConfigType.UnitConfig> usergroupField;
    @FXML
    private JFXCheckBox isAdmin;
    @FXML
    private JFXCheckBox isOccupant;
    @FXML
    private ObserverButton registerBtn;
    @FXML
    private ObserverLabel usernameEmptyLabel;
    @FXML
    private ObserverLabel firstnameEmptyLabel;
    @FXML
    private ObserverLabel lastnameEmptyLabel;
    @FXML
    private ObserverLabel mailEmptyLabel;

    public void initialize() {
        ObservableList<UnitConfigType.UnitConfig> groups = AuthorizationGroups.getAuthorizationGroups();
        groups.addListener(c -> this.setGroups(groups));
        this.registerBtn.getStyleClass().clear();
        this.registerBtn.getStyleClass().add((Object)"transparent-button");
        this.registerBtn.setApplyOnNewText(String::toUpperCase);
        this.usergroupField.setConverter(AuthorizationGroups.stringConverter(groups));
        this.usergroupField.prefWidthProperty().bind((ObservableValue)this.root.widthProperty());
        this.usernameEmptyLabel.getStyleClass().remove((Object)"label");
        this.firstnameEmptyLabel.getStyleClass().remove((Object)"label");
        this.lastnameEmptyLabel.getStyleClass().remove((Object)"label");
        this.mailEmptyLabel.getStyleClass().remove((Object)"label");
    }

    private void setGroups(ObservableList<UnitConfigType.UnitConfig> groups) {
        Platform.runLater(() -> this.usergroupField.getItems().setAll((Collection)groups));
    }

    @FXML
    private void register() throws InterruptedException {
        this.resetHints();
        if (!this.sessionManager.isAdmin()) {
            return;
        }
        try {
            this.sessionManager.verifyUserName(this.username.getText());
        }
        catch (VerificationFailedException ex) {
            this.username.getStyleClass().add((Object)"text-field-wrong");
            this.usernameEmptyLabel.setVisible(true);
            return;
        }
        if (this.firstname.getText().equals("")) {
            this.firstname.getStyleClass().add((Object)"text-field-wrong");
            this.firstnameEmptyLabel.setVisible(true);
            return;
        }
        if (this.lastname.getText().equals("")) {
            this.lastname.getStyleClass().add((Object)"text-field-wrong");
            this.lastnameEmptyLabel.setVisible(true);
            return;
        }
        try {
            this.sessionManager.verifyPasswords(this.passwordField.getText(), this.repeatPasswordField.getText());
        }
        catch (VerificationFailedException ex) {
            this.passwordField.getStyleClass().add((Object)"password-field-wrong");
            this.repeatPasswordField.getStyleClass().add((Object)"password-field-wrong");
            return;
        }
        try {
            this.sessionManager.verifyPhoneNumber(this.phone.getText());
        }
        catch (VerificationFailedException ex) {
            this.phone.getStyleClass().add((Object)"text-field-wrong");
            return;
        }
        try {
            this.sessionManager.verifyMailAddress(this.mail.getText());
        }
        catch (VerificationFailedException ex) {
            this.mail.getStyleClass().add((Object)"text-field-wrong");
            this.mailEmptyLabel.setVisible(true);
            return;
        }
        ObservableList groups = this.usergroupField.getCheckModel().getCheckedItems();
        UserConfigType.UserConfig user = UserConfigType.UserConfig.newBuilder().setUserName(this.username.getText()).setFirstName(this.firstname.getText()).setLastName(this.lastname.getText()).setEmail(this.mail.getText()).setMobilePhoneNumber(this.phone.getText()).setOccupant(this.isOccupant.isSelected()).build();
        try {
            this.sessionManager.registerUser(user, this.passwordField.getText(), this.isAdmin.isSelected(), (List<UnitConfigType.UnitConfig>)groups);
            this.resetFields();
            this.showSuccessMessage();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)logger);
            this.showErrorMessage();
        }
    }

    private void resetHints() {
        this.username.getStyleClass().removeAll((Object[])new String[]{"text-field-wrong"});
        this.firstname.getStyleClass().removeAll((Object[])new String[]{"text-field-wrong"});
        this.lastname.getStyleClass().removeAll((Object[])new String[]{"text-field-wrong"});
        this.passwordField.getStyleClass().removeAll((Object[])new String[]{"password-field-wrong"});
        this.repeatPasswordField.getStyleClass().removeAll((Object[])new String[]{"password-field-wrong"});
        this.usernameEmptyLabel.setVisible(false);
        this.firstnameEmptyLabel.setVisible(false);
        this.lastnameEmptyLabel.setVisible(false);
        this.mailEmptyLabel.setVisible(false);
    }

    private void resetFields() {
        this.username.setText("");
        this.firstname.setText("");
        this.lastname.setText("");
        this.mail.setText("");
        this.phone.setText("");
        this.passwordField.setText("");
        this.repeatPasswordField.setText("");
        this.isAdmin.setSelected(false);
        this.usergroupField.getCheckModel().clearChecks();
    }

    private void showSuccessMessage() {
        InfoPane.info("saveSuccess").backgroundColor(Color.GREEN).hideAfter(Duration.seconds((double)5.0));
    }

    private void showErrorMessage() {
        InfoPane.info("saveError").backgroundColor(Color.RED).hideAfter(Duration.seconds((double)5.0));
    }

    public Pane getRoot() {
        return this.root;
    }
}

