/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.controller;

import com.jfoenix.controls.JFXCheckBox;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.controlsfx.control.textfield.CustomTextField;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.bco.bcozy.model.LanguageSelection;
import org.openbase.bco.bcozy.util.Language;
import org.openbase.bco.bcozy.util.Languages;
import org.openbase.bco.bcozy.view.ForegroundPane;
import org.openbase.bco.bcozy.view.InfoPane;
import org.openbase.bco.bcozy.view.ObserverButton;
import org.openbase.bco.bcozy.view.SVGIcon;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.user.UserConfigType;

public class UserSettingsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserSettingsController.class);
    @FXML
    private CustomTextField changeUsername;
    @FXML
    private CustomTextField changeFirstname;
    @FXML
    private CustomTextField changeLastname;
    @FXML
    private CustomTextField changeMail;
    @FXML
    private CustomTextField changePhone;
    @FXML
    private VBox root;
    @FXML
    private ChoiceBox<String> themeChoice;
    @FXML
    private ChoiceBox<Language> languageChoice;
    @FXML
    private JFXCheckBox isOccupantField;
    @FXML
    private TitledPane changePasswordPane;
    @FXML
    private PasswordField oldPassword;
    @FXML
    private PasswordField newPassword;
    @FXML
    private PasswordField repeatedPassword;
    @FXML
    private ObserverButton savePassword;
    private ObservableList<String> availableThemes;
    private ObservableList<Language> availableLanguages;
    private final ForegroundPane foregroundPane;

    public UserSettingsController(ForegroundPane foregroundPane) {
        this.foregroundPane = foregroundPane;
    }

    public void initialize() {
        SessionManager.getInstance().addLoginObserver((o, b) -> {
            LOGGER.warn("isLoggedIn is " + b);
            if (b != null) {
                this.onLogin();
            }
        });
        this.initEditableFields(this.changeUsername, this.changeFirstname, this.changeLastname, this.changeMail, this.changePhone);
        this.initializeLanguages();
        ResourceBundle languageBundle = ResourceBundle.getBundle("languages.languages", Locale.getDefault());
        this.availableThemes = FXCollections.observableArrayList((Object[])new String[]{languageBundle.getString("light"), languageBundle.getString("dark")});
        this.themeChoice.setItems(this.availableThemes);
        this.savePassword.setApplyOnNewText(String::toUpperCase);
        this.changePasswordPane.setExpanded(false);
    }

    private void initializeLanguages() {
        this.availableLanguages = FXCollections.observableList(Languages.getInstance().get());
        this.languageChoice.setItems(this.availableLanguages);
        this.languageChoice.setConverter((StringConverter)new StringConverter<Language>(){

            public String toString(Language object) {
                return object.getName();
            }

            public Language fromString(String string) {
                return Languages.getInstance().get(string);
            }
        });
        this.languageChoice.getSelectionModel().select((Object)Languages.getInstance().get(Locale.getDefault()));
        this.languageChoice.getSelectionModel().selectedItemProperty().addListener((observable, oldLocale, newLocale) -> {
            if (newLocale != null) {
                LanguageSelection.getInstance().setSelectedLocale(newLocale.getLocale());
            }
        });
    }

    private void updateOccupant(Boolean isOccupant) {
        try {
            UserConfigType.UserConfig userConfig = Registries.getUserRegistry().getUserConfigById(SessionManager.getInstance().getUserId()).getUserConfig().toBuilder().setOccupant(isOccupant.booleanValue()).build();
            UnitConfigType.UnitConfig unitConfig = Registries.getUserRegistry().getUserConfigById(SessionManager.getInstance().getUserId()).toBuilder().setUserConfig(userConfig).build();
            Future saved = Registries.getUserRegistry().updateUserConfig(unitConfig);
            boolean savedValue = ((UnitConfigType.UnitConfig)saved.get(5L, TimeUnit.SECONDS)).getUserConfig().getOccupant();
            if (savedValue == isOccupant) {
                this.showSuccessMessage();
                return;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException | TimeoutException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
        this.showErrorMessage();
    }

    private void onLogin() throws InterruptedException {
        LOGGER.warn("UserID is " + SessionManager.getInstance().getUserId());
        try {
            this.initUserName();
            this.initFirstName();
            this.initLastName();
            this.initMail();
            this.initPhone();
            this.initOccupant();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
    }

    private void initOccupant() throws InterruptedException, CouldNotPerformException {
        this.isOccupantField.setSelected(Registries.getUserRegistry().getUserConfigById(SessionManager.getInstance().getUserId()).getUserConfig().getOccupant());
        this.isOccupantField.selectedProperty().addListener((observable, oldValue, newValue) -> this.updateOccupant((Boolean)newValue));
    }

    private void initPhone() throws InterruptedException, CouldNotPerformException {
        this.changePhone.setText(Registries.getUserRegistry().getUserConfigById(SessionManager.getInstance().getUserId()).getUserConfig().getMobilePhoneNumber());
    }

    private void initMail() throws InterruptedException, CouldNotPerformException {
        this.changeMail.setText(Registries.getUserRegistry().getUserConfigById(SessionManager.getInstance().getUserId()).getUserConfig().getEmail());
    }

    private void initUserName() throws InterruptedException, CouldNotPerformException {
        this.changeUsername.setText(Registries.getUserRegistry().getUserConfigById(SessionManager.getInstance().getUserId()).getUserConfig().getUserName());
    }

    private void initFirstName() throws InterruptedException, CouldNotPerformException {
        this.changeFirstname.setText(Registries.getUserRegistry().getUserConfigById(SessionManager.getInstance().getUserId()).getUserConfig().getFirstName());
    }

    private void initLastName() throws InterruptedException, CouldNotPerformException {
        this.changeLastname.setText(Registries.getUserRegistry().getUserConfigById(SessionManager.getInstance().getUserId()).getUserConfig().getLastName());
    }

    private void initEditableFields(CustomTextField ... fields) {
        for (CustomTextField field : fields) {
            Button editButton = new Button("");
            editButton.setGraphic((Node)new SVGIcon((GlyphIcons)FontAwesomeIcon.PENCIL, 16.0, true));
            editButton.setOnAction(a -> {
                if (field.isEditable()) {
                    try {
                        this.saveUserSettings();
                        field.setEditable(false);
                        editButton.setGraphic((Node)new SVGIcon((GlyphIcons)FontAwesomeIcon.PENCIL, 16.0, true));
                    }
                    catch (InterruptedException ex) {
                        ExceptionPrinter.printHistory((String)"Could not save user settings!", (Throwable)ex, (Logger)LOGGER);
                        Thread.currentThread().interrupt();
                    }
                } else {
                    field.setEditable(true);
                    editButton.setGraphic((Node)new SVGIcon((GlyphIcons)FontAwesomeIcon.FLOPPY_ALT, 16.0, true));
                }
            });
            field.setEditable(false);
            field.setRight((Node)editButton);
        }
    }

    private void saveUserSettings() throws InterruptedException {
        try {
            UnitConfigType.UnitConfig.Builder newUserConfig = Registries.getUserRegistry().getUserConfigById(SessionManager.getInstance().getUserId()).toBuilder();
            newUserConfig.getUserConfigBuilder().setUserName(this.changeUsername.getText()).setFirstName(this.changeFirstname.getText()).setLastName(this.changeLastname.getText()).setEmail(this.changeMail.getText()).setMobilePhoneNumber(this.changePhone.getText()).setOccupant(this.isOccupantField.isSelected());
            Registries.getUserRegistry().updateUserConfig(newUserConfig.build());
            this.showSuccessMessage();
        }
        catch (CouldNotPerformException ex) {
            this.showErrorMessage();
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
    }

    @FXML
    private void saveNewPassword() throws InterruptedException {
        if (!this.verifyNewPassword()) {
            InfoPane.warn("passwordsNotEqual").hideAfter(Duration.seconds((double)5.0));
            this.clearPasswordFields();
            return;
        }
        try {
            SessionManager.getInstance().changeCredentials(SessionManager.getInstance().getUserId(), this.oldPassword.getText(), this.newPassword.getText());
            this.showSuccessMessage();
        }
        catch (RejectedException rex) {
            InfoPane.info("oldPasswordWrong").backgroundColor(Color.RED).hideAfter(Duration.seconds((double)5.0));
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
        }
        this.clearPasswordFields();
    }

    private void clearPasswordFields() {
        this.oldPassword.clear();
        this.newPassword.clear();
        this.repeatedPassword.clear();
    }

    private boolean verifyNewPassword() {
        return this.newPassword.getText().equals(this.repeatedPassword.getText());
    }

    private void showSuccessMessage() {
        InfoPane.info("saveSuccess").backgroundColor(Color.GREEN).hideAfter(Duration.seconds((double)5.0));
    }

    private void showErrorMessage() {
        InfoPane.info("saveError").backgroundColor(Color.RED).hideAfter(Duration.seconds((double)5.0));
    }

    public ChoiceBox<String> getThemeChoice() {
        return this.themeChoice;
    }

    public ChoiceBox<Language> getLanguageChoice() {
        return this.languageChoice;
    }

    public ObservableList<String> getAvailableThemes() {
        return this.availableThemes;
    }

    public ObservableList<Language> getAvailableLanguages() {
        return this.availableLanguages;
    }

    public VBox getRoot() {
        return this.root;
    }
}

