/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openbase.bco.bcozy.util.Language;

public class Languages {
    private final Language english = this.fromLocale(Locale.US);
    private final List<Language> languages;

    public static Languages getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private Languages() {
        List<Locale> bundles = this.getLocalesFromBundles();
        this.languages = bundles.stream().map(this::fromLocale).collect(Collectors.toList());
    }

    private Language fromLocale(Locale locale) {
        return new Language(locale, locale.getDisplayLanguage(locale));
    }

    private List<Locale> getLocalesFromBundles() {
        List<String> matches = this.getFileMatches();
        ArrayList<Locale> locales = new ArrayList<Locale>(matches.size());
        for (String match : matches) {
            if (match.contains("_")) {
                locales.add(new Locale(match.split("_")[0], match.split("_")[1]));
                continue;
            }
            locales.add(new Locale(match));
        }
        return locales;
    }

    private List<String> getFileMatches() {
        LinkedList<String> matches = new LinkedList<String>();
        Pattern pattern = Pattern.compile("languages_(\\w+[_\\w+])\\.properties");
        for (File file : this.getResourceFolderFiles("languages")) {
            Matcher matcher = pattern.matcher(file.getName());
            if (!matcher.find()) continue;
            matches.add(matcher.group(1));
        }
        return matches;
    }

    private File[] getResourceFolderFiles(String folder) {
        ClassLoader loader = Languages.class.getClassLoader();
        URL url = loader.getResource(folder);
        String path = url.getPath();
        return new File(path).listFiles();
    }

    public Language get(Locale locale) {
        return this.languages.stream().filter(l -> Objects.equals(l.getLocale(), locale)).findAny().orElse(this.english);
    }

    public Language get(String name) {
        return this.languages.stream().filter(l -> Objects.equals(l.getName(), name)).findAny().orElse(this.english);
    }

    public List<Language> get() {
        return this.languages;
    }

    private static final class InstanceHolder {
        static final Languages INSTANCE = new Languages();

        private InstanceHolder() {
        }
    }
}

