/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.bcozy.view;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialicons.MaterialIcon;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import org.openbase.bco.bcozy.view.SVGIcon;

public class AdvancedHorizontalSlider
extends Pane {
    private final Rectangle sliderBackground;
    private final Rectangle sliderActualStatus;
    private final Circle thumb;
    private final StackPane topLabelPane;
    private final StackPane bottomLabelPane;
    private final SVGIcon topLabelShape;
    private final SVGIcon bottomLabelShape;
    private final Label topLabel;
    private final Label bottomLabel;
    private final VBox verticalLayout;
    private final StackPane slider;
    private final double minValue;
    private final double maxValue;

    public AdvancedHorizontalSlider(double minValue, double maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.sliderBackground = new Rectangle(200.0, 5.0);
        this.sliderBackground.getStyleClass().add((Object)"advanced-horizontal-slider-background");
        this.sliderActualStatus = new Rectangle(0.0, 5.0);
        this.sliderActualStatus.getStyleClass().add((Object)"advanced-horizontal-slider-highlight");
        this.thumb = new Circle(10.0);
        this.thumb.getStyleClass().add((Object)"advanced-horizontal-slider-thumb");
        this.thumb.setFill((Paint)Color.SLATEGRAY);
        this.slider = new StackPane(new Node[]{this.sliderBackground, this.sliderActualStatus, this.thumb});
        this.slider.setOnMouseDragged(event -> this.addMouseEventHandler((MouseEvent)event));
        this.slider.setOnMouseClicked(event -> this.addMouseEventHandler((MouseEvent)event));
        StackPane.setAlignment((Node)this.sliderBackground, (Pos)Pos.CENTER_LEFT);
        StackPane.setAlignment((Node)this.sliderActualStatus, (Pos)Pos.CENTER_LEFT);
        StackPane.setAlignment((Node)this.thumb, (Pos)Pos.CENTER_LEFT);
        this.topLabelShape = new SVGIcon((GlyphIcons)MaterialIcon.CHAT_BUBBLE, 48.0, false);
        this.topLabel = new Label("");
        this.topLabelShape.getStyleClass().addAll((Object[])new String[]{"small-label", "advanced-horizontal-slider-label-top"});
        this.bottomLabelShape = new SVGIcon((GlyphIcons)MaterialIcon.CHAT_BUBBLE, 48.0, false);
        this.bottomLabelShape.setRotate(180.0);
        this.bottomLabel = new Label("");
        this.bottomLabel.getStyleClass().add((Object)"small-label");
        this.bottomLabelShape.getStyleClass().add((Object)"advanced-horizontal-slider-label-bottom");
        this.topLabelPane = new StackPane(new Node[]{this.topLabelShape, this.topLabel});
        this.bottomLabelPane = new StackPane(new Node[]{this.bottomLabelShape, this.bottomLabel});
        this.verticalLayout = new VBox(new Node[]{this.topLabelPane, this.slider, this.bottomLabelPane});
        this.getChildren().add((Object)this.verticalLayout);
    }

    private void addMouseEventHandler(MouseEvent event) {
        double xValue = event.getX();
        if (xValue < this.sliderBackground.getWidth() + this.thumb.getRadius() && xValue > this.sliderBackground.getX() + this.thumb.getRadius() / 2.0) {
            this.sliderActualStatus.setWidth(xValue);
            this.thumb.setTranslateX(xValue - this.thumb.getRadius());
            this.bottomLabel.setText((this.maxValue - this.minValue) * xValue / this.sliderBackground.getWidth() + this.minValue + "\u00b0C");
            this.bottomLabelPane.setTranslateX(xValue);
        }
    }
}

